/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.InternationalizedConverter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class DateConverter
extends InternationalizedConverter {
    public DateConverter() {
        this("{**$day}.{**$month}.{****$year}#DD.MM.YYYY$0123456789DMY$0123456789");
    }

    public DateConverter(String pattern) {
        super(pattern);
    }

    @Override
    public Object inverseConvert(Object o, Object userObj) {
        Time currentTime = null;
        if (userObj instanceof Time) {
            currentTime = (Time)userObj;
        } else if (userObj instanceof java.sql.Date) {
            currentTime = new Time(((java.sql.Date)userObj).getTime());
        } else if (userObj instanceof Timestamp) {
            currentTime = new Time(((Timestamp)userObj).getTime());
        }
        int aHour = currentTime != null ? DateUtil.getHourOfDay((Date)currentTime) : 0;
        int aMinute = currentTime != null ? DateUtil.getMinuteOfHour((Date)currentTime) : 0;
        int aSecond = currentTime != null ? DateUtil.getSecondsOfMinute((Date)currentTime) : 0;
        String dString = (String)o;
        if (dString == null || dString.trim().equals("")) {
            return null;
        }
        String day = this.getStringValueOfGroupNamed("day", dString);
        String month = this.getStringValueOfGroupNamed("month", dString);
        String year = this.getStringValueOfGroupNamed("year", dString);
        try {
            int aDay = Integer.valueOf(day);
            int aMonth = Integer.valueOf(month);
            int aYear = Integer.valueOf(year);
            try {
                if (userObj instanceof Timestamp) {
                    return DateUtil.getTimestamp((int)aYear, (int)aMonth, (int)aDay, (int)aHour, (int)aMinute, (int)aSecond);
                }
                return DateUtil.getSQLDate((int)aYear, (int)aMonth, (int)aDay);
            }
            catch (Exception e) {
                return userObj;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String convert(Object o, Node currentNode, Object ... param) {
        Time d = null;
        if (o instanceof Time) {
            d = (Time)o;
        } else if (o instanceof java.sql.Date) {
            d = new Time(((java.sql.Date)o).getTime());
        } else if (o instanceof Timestamp) {
            d = new Time(((Timestamp)o).getTime());
        }
        Calendar c = TimeUtil.createCalendar();
        if (d == null) {
            return "";
        }
        c.setTime(d);
        int d1 = c.get(5);
        int m1 = c.get(2);
        int y1 = c.get(1);
        if (d1 == 6 && m1 == 6 && y1 == 6666) {
            return "\u221e";
        }
        if (y1 == 6666) {
            return "\u221e";
        }
        String retString = "";
        for (String pat : this.getAllPatterns()) {
            if (pat.contains("$")) {
                String hS;
                int h;
                if (pat.equals("$day")) {
                    h = c.get(5);
                    hS = "" + h;
                    if (hS.length() == 1) {
                        hS = "0" + hS;
                    }
                    retString = retString + hS;
                    continue;
                }
                if (pat.equals("$month")) {
                    h = c.get(2);
                    hS = "" + ++h;
                    if (hS.length() == 1) {
                        hS = "0" + hS;
                    }
                    retString = retString + hS;
                    continue;
                }
                if (!pat.equals("$year")) continue;
                h = c.get(1);
                hS = "" + h;
                while (hS.length() < 4) {
                    hS = "0" + hS;
                }
                retString = retString + hS;
                continue;
            }
            retString = retString + pat;
        }
        return retString;
    }

    @Override
    public boolean validateInput(Object input) {
        String dString = (String)input;
        String day = this.getStringValueOfGroupNamed("day", dString);
        String month = this.getStringValueOfGroupNamed("month", dString);
        String year = this.getStringValueOfGroupNamed("year", dString);
        try {
            int aDay = Integer.valueOf(day);
            int aMonth = Integer.valueOf(month);
            int aYear = Integer.valueOf(year);
            if (aDay < 1 || aDay > 31) {
                return false;
            }
            if (aMonth < 1 || aMonth > 12) {
                return false;
            }
            Calendar c = TimeUtil.createCalendar();
            c.set(5, aDay);
            c.set(2, aMonth - 1);
            c.set(1, aYear);
            long time = c.getTimeInMillis();
            c.setTimeInMillis(time);
            int nDay = c.get(5);
            if (nDay != aDay) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

