/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.Collections;

public class PaxConfigConverter
implements Converter<FlightLight, String> {
    @Override
    public String convert(FlightLight o, Node<FlightLight> currentNode, Object ... param) {
        if (o == null) {
            return NULL_RETURN;
        }
        String ret = "";
        for (FlightLegComplete l : o.getLegs()) {
            if (!l.getCateringLeg().booleanValue()) continue;
            Collections.sort(l.getPaxFigures());
            ret = ret + Words.LEG + " " + (l.getNumber() + 1) + ": ";
            String t = "";
            for (PaxFigureComplete f : l.getPaxFigures()) {
                if (f.getPaxFigureType() != null) continue;
                t = t + f.getCabinClass().getCode() + "(" + f.getNumber() + ") ";
            }
            if (!t.isEmpty()) {
                t = t.substring(0, t.length() - 1);
            }
            ret = ret + t;
            ret = ret + ", ";
        }
        if (!ret.isEmpty()) {
            ret = ret.substring(0, ret.length() - 2);
        }
        return ret;
    }

    @Override
    public Class<? extends FlightLight> getParameterClass() {
        return FlightLight.class;
    }
}

