/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;

public class ProductVariantListViewConverter
implements Converter<ProductVariantLight, String> {
    @Override
    public String convert(ProductVariantLight o, Node<ProductVariantLight> currentNode, Object ... param) {
        ProductVariantLight l = currentNode.getValue(ProductVariantLight.class);
        if (l == null) {
            return "-";
        }
        DateConverter c = ConverterRegistry.getConverter(DateConverter.class);
        String prefix = Boolean.TRUE.equals(l.getTenderVariant()) ? "Tender:" : "Productive:";
        Integer n = l.getProduct() != null ? l.getProduct().getNumber() : l.getProductNumber();
        return prefix + " " + n + " - " + l.getName() + " (" + c.convert(l.getValidityPeriod().getStartDate(), (Node)null, new Object[0]) + " - " + c.convert(l.getValidityPeriod().getEndDate(), (Node)null, new Object[0]) + ")";
    }

    @Override
    public Class<? extends ProductVariantLight> getParameterClass() {
        return ProductVariantLight.class;
    }
}

