/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.search.impls.remote;

import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.exception.SearchException;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealplanTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.search.CateringServiceScheduleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class CateringServiceSearchAlgorithm
extends SearchAlgorithm<CateringServiceScheduleComplete> {
    private List<Node<CateringServiceScheduleComplete>> allValues = new ArrayList<Node<CateringServiceScheduleComplete>>();

    public void setAllValues(List<Node<CateringServiceScheduleComplete>> allValues) {
        this.allValues = allValues;
    }

    @Override
    public ASearchConfiguration<CateringServiceScheduleComplete, ? extends Enum<?>> getSearchConfiguration() {
        return new CateringServiceScheduleSearchConfiguration();
    }

    @Override
    public ViewNode<SearchResult<CateringServiceScheduleComplete>> search(ASearchConfiguration<CateringServiceScheduleComplete, ? extends Enum<?>> conf) throws SearchException, ClientServerCallException {
        CateringServiceScheduleSearchConfiguration config = (CateringServiceScheduleSearchConfiguration)conf;
        ArrayList<CateringServiceScheduleComplete> list = new ArrayList<CateringServiceScheduleComplete>();
        for (Node<CateringServiceScheduleComplete> allValue : this.allValues) {
            CateringServiceScheduleComplete value = allValue.getValue(CateringServiceScheduleComplete.class);
            boolean take = true;
            if (!config.getLegs().isEmpty()) {
                boolean matchLeg = false;
                for (MealplanTemplateLegComplete leg : config.getLegs()) {
                    if (!value.getLegs().contains(leg)) continue;
                    matchLeg = true;
                }
                if (!matchLeg) {
                    take = false;
                }
            }
            if (config.getCabinClass() != null && !config.getCabinClass().equals((Object)value.getCabinClass())) {
                take = false;
            }
            if (config.getServiceType() != null && !config.getServiceType().equals((Object)value.getType())) {
                take = false;
            }
            if (config.getIsDeleted() != null) {
                if (Boolean.TRUE.equals(config.getIsDeleted())) {
                    if (!Boolean.TRUE.equals(value.getIsDeleted())) {
                        take = false;
                    }
                } else if (Boolean.TRUE.equals(value.getIsDeleted())) {
                    take = false;
                }
            }
            if (!StringUtil.isBlank((String)config.getSearchName())) {
                String serviceString = "";
                for (MealplanTemplateLegComplete leg : value.getLegs()) {
                    serviceString = serviceString + "Leg " + (leg.getNumber() + 1) + ", ";
                }
                serviceString = serviceString + value.getType().getCode() + ", ";
                if (!(serviceString = serviceString + value.getCabinClass().getCode()).toLowerCase().contains(config.getSearchName().toLowerCase())) {
                    take = false;
                }
            }
            if (!take) continue;
            list.add(value);
        }
        ViewNode<SearchResult<CateringServiceScheduleComplete>> node = new ViewNode<SearchResult<CateringServiceScheduleComplete>>("");
        SearchResult result = new SearchResult();
        result.setResults(list);
        result.setNumberOfResults(Long.valueOf(list.size()));
        result.setPageNumber(Integer.valueOf(1));
        result.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        node.setValue(result, 0L);
        return node;
    }
}

