/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.search.impls.remote;

import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.exception.SearchException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StoreArticleContentSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreArticleContentComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.util.HashMap;
import java.util.Iterator;

public class StoreArticleContentSearchAlgorithm
extends SearchAlgorithm<StoreArticleContentComplete> {
    @Override
    public ViewNode<SearchResult<StoreArticleContentComplete>> search(ASearchConfiguration<StoreArticleContentComplete, ? extends Enum<?>> conf) throws SearchException, ClientServerCallException {
        SearchResult<StoreArticleContentComplete> l;
        StoreArticleContentSearchConfiguration c = (StoreArticleContentSearchConfiguration)conf;
        BasicArticleSearchConfiguration basc = this.convertToBasicArticleSearchConfiguration(c);
        HashMap index = new HashMap();
        try {
            l = ServiceManagerRegistry.getService(StoreServiceManager.class).getStoreArticleContent(basc);
            if (l.getResults() != null) {
                for (StoreArticleContentComplete s : l.getResults()) {
                    if (s.getStoreQuantity().getAmount() == null) {
                        s.getStoreQuantity().setAmount(Long.valueOf(0L));
                    }
                    if (s.getStoreQuantity().getUnit() == null) {
                        s.getStoreQuantity().setUnit(StoreToolkit.getInventoryUnit((BasicArticleLight)s.getArticle(), null));
                    }
                    BasicArticleComplete artC = (BasicArticleComplete)ServiceManagerRegistry.getService(SupplyServiceManager.class).getBasicArticle(new BasicArticleReference(s.getArticle().getId())).getValue();
                    s.setArticle((BasicArticleLight)artC);
                    for (ArticleChargeBatchComplete batch : s.getBatches()) {
                        batch.getCharge().setBasicArticle((BasicArticleLight)artC);
                    }
                }
                Iterator it = l.getResults().iterator();
                while (it.hasNext()) {
                    if (!((StoreArticleContentComplete)it.next()).getBatches().isEmpty()) continue;
                    it.remove();
                }
            }
        }
        catch (ServiceException e) {
            throw new SearchException("Error searching Store Content", (Exception)((Object)e));
        }
        for (StoreArticleContentComplete a : l.getResults()) {
            if (a.getClientOId() != null) continue;
            a.setClientOId(Long.valueOf(ADTO.getNextId()));
        }
        ViewNode<SearchResult<StoreArticleContentComplete>> rets = new ViewNode<SearchResult<StoreArticleContentComplete>>("Returns");
        rets.setValue(l, 0L);
        return rets;
    }

    public BasicArticleSearchConfiguration convertToBasicArticleSearchConfiguration(StoreArticleContentSearchConfiguration c) {
        BasicArticleSearchConfiguration basc = new BasicArticleSearchConfiguration();
        basc.setAllergenApproved(c.getAllergenApproved());
        basc.setAttribute1Category(c.getAttribute1Category());
        basc.setAttribute2Category(c.getAttribute2Category());
        basc.setAttribute3Category(c.getAttribute3Category());
        basc.setBondedOnly(c.getBondedOnly());
        basc.setCharge(c.getCharge());
        basc.setContracted(c.getContracted());
        basc.setCustomer(c.getCustomer());
        basc.setCustomerArticleNo(c.getCustomerArticleNo());
        basc.setCustomerOwned(c.getCustomerOwned());
        basc.setCustomsDocumentType(c.getCustomsDocumentType());
        basc.setDefaultDepartment(c.getDefaultDepartment());
        basc.setFromNO(c.getFromNO());
        basc.setGmcActive(c.getGmcActive());
        basc.setInUse(c.getInUse());
        basc.setIsDeleted(c.getIsDeleted());
        basc.setIsNominated(c.getIsNominated());
        basc.setLocations(c.getLocations());
        basc.setMainGroup(c.getMainGroup());
        basc.setName(c.getName());
        basc.setNumber(c.getNumber());
        basc.setNumResults(c.getNumResults());
        basc.setOwnershipCategory(c.getOwnershipCategory());
        basc.setPageNumber(c.getPageNumber());
        basc.setPriceFactor(c.getPriceFactor());
        basc.setSearchtype(c.getSearchtype());
        basc.setSortColumn(c.getSortColumn());
        basc.setSortDirection(c.getSortDirection());
        basc.setSupplier(c.getSupplier());
        basc.setStorePosition(c.getStorePosition());
        basc.setStore(c.getStore());
        basc.setSupplierArticleNumber(c.getSupplierArticleNumber());
        basc.setTemperatureCategory(c.getTemperatureCategory());
        basc.setToNO(basc.getToNO());
        basc.setUsedPeriod(c.getUsedPeriod());
        return basc;
    }

    @Override
    public ASearchConfiguration<StoreArticleContentComplete, ? extends Enum<?>> getSearchConfiguration() {
        return new StoreArticleContentSearchConfiguration();
    }
}

