/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services;

import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.util.DebugTextListener;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ProxyInvocationHandler
implements InvocationHandler {
    private static List<DebugTextListener> listeners = new ArrayList<DebugTextListener>();

    public static void registerDebugListener(DebugTextListener listener) {
        listeners.add(listener);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object instance = ServiceManagerRegistry.getClassForState(method.getDeclaringClass(), ServiceManagerRegistry.getMethodState(method.getDeclaringClass().getName(), method.getName()));
        SimpleDateFormat sdf = TimeUtil.createDateFormat((String)"HH:mm:ss");
        for (DebugTextListener listener : listeners) {
            listener.debugText(sdf.format(new Date()).toString() + "   -    " + method.getDeclaringClass().getSimpleName() + "." + method.getName(), method, method.getDeclaringClass());
        }
        try {
            return method.invoke(instance, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

