/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter3Decimals;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.PriceToolkit;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;

public class BreadCrumbPriceConverter
implements Converter<PriceComplete, String> {
    @Override
    public String convert(PriceComplete o, Node<PriceComplete> currentNode, Object ... param) {
        if (o == null) {
            return NULL_RETURN;
        }
        if (o.getCurrency() == null) {
            SystemSettingsComplete settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            o.setCurrency(settings.getCurrency());
        }
        o.setPrice(PriceToolkit.ensureDoubleFinite(o.getPrice()));
        FormattedDoubleConverter3Decimals conv = ConverterRegistry.getConverter(FormattedDoubleConverter3Decimals.class);
        String fr = conv.convert(o.getPrice(), (Node<Number>)null, new Object[0]);
        return fr + " " + o.getCurrency().getCode();
    }

    @Override
    public Class<? extends PriceComplete> getParameterClass() {
        return PriceComplete.class;
    }
}

