/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter2;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;
import javax.swing.text.MaskFormatter;

public abstract class InternationalizedConverter
implements Converter2<Object, String> {
    protected String pattern;
    private String validInputs;
    private String placeHolderPattern;
    private List<String> fixStrings;
    private List<String> allPatterns;

    public InternationalizedConverter(String pattern) {
        this.pattern = pattern;
        this.getFixStrings();
    }

    @Override
    public Class<?> getParameterClass() {
        return null;
    }

    public List<String> getFixStrings() {
        if (this.fixStrings == null) {
            this.generateMask();
        }
        return this.fixStrings;
    }

    public List<String> getAllPatterns() {
        if (this.allPatterns == null) {
            this.generateMask();
        }
        return this.allPatterns;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getValidInputs() {
        if (this.validInputs == null) {
            this.generateMask();
        }
        return this.validInputs;
    }

    public String getplaceHolderPattern() {
        if (this.placeHolderPattern == null) {
            this.generateMask();
        }
        return this.placeHolderPattern;
    }

    public JFormattedTextField.AbstractFormatter generateMask() {
        String realValidInputs;
        this.allPatterns = new ArrayList<String>();
        this.fixStrings = new ArrayList<String>();
        if (this.pattern == null || this.pattern.equals("")) {
            return new MaskFormatter();
        }
        String maskPattern = "";
        Pattern p = Pattern.compile("\\{|\\}");
        int start = -1;
        int end = -1;
        int count = 0;
        Matcher m = p.matcher(this.pattern);
        boolean result = m.find();
        while (result) {
            if (m.group().equals("{")) {
                if (++count == 1) {
                    start = m.start();
                    if (end != -1) {
                        String fix = this.pattern.substring(end, start);
                        this.fixStrings.add(fix);
                        this.allPatterns.add(fix);
                        maskPattern = maskPattern + fix;
                    }
                }
            } else if (m.group().equals("}") && --count == 0) {
                end = m.end();
                String pat = this.pattern.substring(start, end);
                int i = pat.indexOf("$");
                String patM = pat.substring(1, i);
                String name = pat.substring(i, pat.length() - 1);
                maskPattern = maskPattern + patM;
                this.allPatterns.add(name);
            }
            result = m.find();
        }
        int i = this.pattern.indexOf("#");
        int j = this.pattern.indexOf("$", i);
        this.placeHolderPattern = this.pattern.substring(i + 1, j);
        i = this.pattern.indexOf("$", j + 1);
        String validInputs = this.pattern.substring(j + 1, i);
        this.validInputs = realValidInputs = this.pattern.substring(i + 1, this.pattern.length());
        try {
            MaskFormatter format = new MaskFormatter(maskPattern);
            format.setPlaceholder(this.placeHolderPattern);
            format.setValidCharacters(validInputs);
            format.setCommitsOnValidEdit(true);
            return format;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public String getStringValueOfGroupNamed(String t, String text) {
        int index = -1;
        int i = -1;
        int count = -1;
        i = this.pattern.indexOf("$");
        while (i != -1 && index == -1) {
            String name;
            ++count;
            int j = this.pattern.indexOf("}", i);
            if (j != -1 && (name = this.pattern.substring(i + 1, j)).equals(t)) {
                index = count;
            }
            i = this.pattern.indexOf("$", i + 1);
        }
        if (index != -1) {
            int s = 0;
            int e = 0;
            count = 0;
            for (String fix : this.fixStrings) {
                e = text.indexOf(fix, s + 1);
                if (count != 0) {
                    ++s;
                }
                if (e == -1) {
                    return null;
                }
                String tempS = text.substring(s, e);
                if (count == index) {
                    return tempS;
                }
                s = e;
                ++count;
            }
            if (count == index) {
                String tempS = text.substring(s + 1, text.length());
                return tempS;
            }
        }
        return null;
    }
}

