/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.node;

import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.ObjectWrapper;
import ch.icit.pegasus.client.node.impls.CommitNode;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.AEmbeddedDTO;
import ch.icit.pegasus.server.core.dtos.report.AReportConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.util.Invoker;
import ch.icit.util.InvokerException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DTONodeCreator
extends INodeCreator {
    private final Map<Object, Node<?>> allNodes = new HashMap();

    @Override
    public void clearAllNonPermanentNodes() {
        Iterator<Map.Entry<Object, Node<?>>> it = this.allNodes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Node<?>> n = it.next();
            if (n.getValue().isPermanent()) continue;
            it.remove();
            n.getValue().kill();
        }
        NodeToolkit.clearNonPermanentValues();
    }

    @Override
    public void clearAllNodes() {
        this.allNodes.clear();
        NodeToolkit.treeOfLife.clear();
    }

    @Override
    public <VALUE_TYPE> void addToAllNodes(Node<VALUE_TYPE> n) {
        if (n.getValue() != null) {
            VALUE_TYPE o = n.getValue();
            if (o instanceof AEmbeddedDTO || o instanceof ADTO) {
                Node<?> ret = this.allNodes.get(new ObjectWrapper<VALUE_TYPE>(o));
                if (ret == null) {
                    this.allNodes.put(new ObjectWrapper<VALUE_TYPE>(o), n);
                }
            } else if (o instanceof List && n instanceof Node) {
                Iterator<Node<?>> i = n.getChilds();
                while (i.hasNext()) {
                    Node<?> nn = i.next();
                    this.addToAllNodes(nn);
                }
            }
        }
    }

    @Override
    public <VALUE_TYPE> void removeFromAllNodes(Node<VALUE_TYPE> n) {
        if (n.getData() != null) {
            for (VALUE_TYPE o : n.getData()) {
                this.allNodes.remove(new ObjectWrapper<VALUE_TYPE>(o));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <VALUE_TYPE> void commitValue(Node<VALUE_TYPE> node, VALUE_TYPE dto) {
        if (dto == null) {
            return;
        }
        String n = node.getName();
        n = n.toLowerCase();
        boolean found = false;
        Field foundField = null;
        List fields = Invoker.getAllFields(dto.getClass(), field -> !Modifier.isStatic(field.getModifiers()));
        for (Field f : fields) {
            if (!f.getName().toLowerCase().equals(n)) continue;
            foundField = f;
            found = true;
        }
        if (found) {
            if (node.getData() == null || node.getData().size() == 0) {
                try {
                    Invoker.setFieldValue((String)node.getName(), node.getValue(), dto, (boolean)true);
                }
                catch (InvokerException e) {
                    e.printStackTrace();
                }
            } else {
                List<VALUE_TYPE> list = node.getData();
                synchronized (list) {
                    if (node.getData().size() > 0) {
                        for (int i = 0; i < node.getData().size(); ++i) {
                            VALUE_TYPE value = node.getData().get(i);
                            if (value == null || !Invoker.getWrapperClass(foundField.getType()).isAssignableFrom(value.getClass())) continue;
                            try {
                                Invoker.setFieldValue((String)node.getName(), value, dto, (boolean)true);
                                continue;
                            }
                            catch (InvokerException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public <VALUE_TYPE> Node<List<VALUE_TYPE>> createNodes(List<VALUE_TYPE> dto, boolean isProxy) {
        return this.createNodes(dto, isProxy, false);
    }

    @Override
    public <VALUE_TYPE> Node<List<VALUE_TYPE>> createNodes(List<VALUE_TYPE> dto, boolean isProxy, boolean updateAfter) {
        Node<List<VALUE_TYPE>> root = this.getNode4Value(dto);
        if (root == null) {
            ListNode r = new ListNode();
            root = r;
            r.setValue(dto, 0L);
            r.setProxyList(isProxy);
            if (dto == null) {
                return null;
            }
            for (VALUE_TYPE d : dto) {
                Node<?> rootDTO = null;
                rootDTO = this.getNode4Field(null, root, d, isProxy, true);
                rootDTO.setValue(d, 0L);
                if (!isProxy) {
                    rootDTO.updateNode();
                }
                root.addChild(rootDTO, 0L);
            }
            this.pushNodeList(root, dto);
        }
        return root;
    }

    private <VALUE_TYPE> Node<VALUE_TYPE> getNode4Value(VALUE_TYPE t) {
        Node<?> n = this.allNodes.get(new ObjectWrapper<VALUE_TYPE>(t));
        if (n != null && t != null) {
            n.setValueSilent(t, true, 0L, null);
        }
        return n;
    }

    @Override
    public <VALUE_TYPE> Node<VALUE_TYPE> getNode4DTO(VALUE_TYPE dto, boolean isListNode, boolean isProxy) {
        return this.getNode4DTO(dto, isListNode, isProxy, true);
    }

    private void updateReference(ProxyNode<Object> node) {
        Node<Object> ref = this.getNode4Value(node.getSource());
        node.setRefNode(ref);
    }

    @Override
    public <VALUE_TYPE> Node<VALUE_TYPE> getNode4DTO(VALUE_TYPE dto, boolean isListNode, boolean isProxy, boolean updateAfter) {
        if (isProxy) {
            DTOProxyNode<Object> proxyNode = new DTOProxyNode<Object>(dto);
            this.updateReference(proxyNode);
            return proxyNode;
        }
        Node<Object> n = this.getNode4Value(dto);
        if (n == null) {
            if (dto instanceof ADTO) {
                DTONode<ADTO> n2 = new DTONode<ADTO>();
                n2.setListChild(isListNode);
                if (dto != null) {
                    n2.setValue((ADTO)dto, 0L);
                    this.pushNodeList(n2, dto);
                }
                return n2;
            }
            if (dto instanceof AEmbeddedDTO) {
                EmbeddedDTONode<AEmbeddedDTO> n2 = new EmbeddedDTONode<AEmbeddedDTO>();
                n2.setListChild(isListNode);
                if (dto != null) {
                    n2.setValue((AEmbeddedDTO)dto, 0L);
                    this.pushNodeList(n2, dto);
                }
                return n2;
            }
            if (dto instanceof ASearchConfiguration) {
                CommitNode<ASearchConfiguration> n2 = new CommitNode<ASearchConfiguration>();
                n2.setListChild(isListNode);
                if (dto != null) {
                    n2.setValue((ASearchConfiguration)dto, 0L);
                    this.pushNodeList(n2, dto);
                }
                return n2;
            }
            if (dto instanceof AReportConfiguration) {
                CommitNode<AReportConfiguration> n2 = new CommitNode<AReportConfiguration>();
                n2.setListChild(isListNode);
                if (dto != null) {
                    n2.setValue((AReportConfiguration)dto, 0L);
                    this.pushNodeList(n2, dto);
                }
                return n2;
            }
            n = new Node();
            n.setValue(dto, 0L);
            if (dto != null) {
                this.pushNodeList(n, dto);
            }
        } else {
            n.setValueSilent(dto, true, 0L, null);
            if (updateAfter) {
                n.updateNode();
            }
        }
        return n;
    }

    @Override
    public Node<?> getNode4Field(Field f, Node<?> parent, Object value, boolean isProxy, boolean isListNode) {
        if (value instanceof AEmbeddedDTO || f != null && AEmbeddedDTO.class.isAssignableFrom(f.getType())) {
            if (value == null) {
                if (isProxy) {
                    DTOProxyNode<AEmbeddedDTO> n = new DTOProxyNode<AEmbeddedDTO>((AEmbeddedDTO)value);
                    n.setOriginField(f);
                    n.setListChild(isListNode);
                    n.setName(f.getName());
                    return n;
                }
                EmbeddedDTONode n = new EmbeddedDTONode(f);
                n.setName(f.getName());
                n.setListChild(isListNode);
                this.pushNodeList(n, value);
                return n;
            }
            return this.getNode4DTO(value, isListNode, isProxy, false);
        }
        if (value instanceof ADTO || f != null && ADTO.class.isAssignableFrom(f.getType())) {
            if (value == null) {
                if (isProxy) {
                    DTOProxyNode<ADTO> n = new DTOProxyNode<ADTO>((ADTO)value);
                    n.setOriginField(f);
                    n.setListChild(isListNode);
                    n.setName(f.getName());
                    return n;
                }
                DTONode n = new DTONode(f);
                n.setName(f.getName());
                n.setListChild(isListNode);
                this.pushNodeList(n, value);
                return n;
            }
            return this.getNode4DTO(value, isListNode, isProxy, false);
        }
        if (value instanceof Collection || f != null && Collection.class.isAssignableFrom(f.getType())) {
            if (value == null) {
                if (isProxy) {
                    DTOProxyNode<Collection> n = new DTOProxyNode<Collection>((Collection)value);
                    n.setOriginField(f);
                    n.setListChild(isListNode);
                    n.setName(f.getName());
                    return n;
                }
                ListNode n = new ListNode(f);
                n.setName(f.getName());
                n.setListChild(isListNode);
                this.pushNodeList(n, value);
                return n;
            }
            return this.createNodes((List)value, isProxy, false);
        }
        Node<Object> n = new Node<Object>(f);
        if (f != null) {
            boolean bl;
            DTOField annotation = f.getAnnotation(DTOField.class);
            boolean bl2 = bl = annotation != null && annotation.maxStringLength() != Integer.MAX_VALUE;
        }
        if (value instanceof Boolean || f != null && Boolean.class.isAssignableFrom(f.getType())) {
            Boolean b = (Boolean)value;
            n.setValue(b, 0L);
        } else {
            n.setValue(value, 0L);
        }
        n.setListChild(isListNode);
        return n;
    }

    @Override
    public <VALUE_TYPE> Node<VALUE_TYPE> getNodeDirectly(VALUE_TYPE t) {
        Node<?> n = this.allNodes.get(new ObjectWrapper<VALUE_TYPE>(t));
        return n;
    }

    @Override
    public Object getNodeValue(String name, Object dto) {
        return null;
    }

    @Override
    public <VALUE_TYPE> void initUpdate(Node<VALUE_TYPE> node) {
        this.updateProxys(node);
    }

    @Override
    public void pushNodeList(Node<?> node, Object value) {
        this.allNodes.put(new ObjectWrapper<Object>(value), node);
    }

    @Override
    public <VALUE_TYPE> void removeNodeFromList(Node<VALUE_TYPE> node, VALUE_TYPE value) {
        if (value != null) {
            this.allNodes.remove(new ObjectWrapper<VALUE_TYPE>(value));
        }
    }

    @Override
    public boolean setNodeValue(Node<Object> node, Object dto) {
        try {
            Field f = Invoker.getField(dto.getClass(), (String)node.getName());
            if (f != null) {
                Annotation[] annos;
                Object nV = Invoker.getFieldValue((Field)f, (Object)dto);
                node.setValue(nV, 0L);
                for (Annotation ano : annos = f.getAnnotations()) {
                    if (!ano.annotationType().equals(DTOField.class)) continue;
                    DTOField dTOField = (DTOField)ano;
                }
                return true;
            }
        }
        catch (InvokerException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public <VALUE_TYPE> void updateProxys(Node<VALUE_TYPE> instruction) {
        Iterator<Node<?>> it = instruction.getChilds();
        ArrayList<Node<VALUE_TYPE>> list = new ArrayList<Node<VALUE_TYPE>>();
        if (it != null) {
            while (it.hasNext()) {
                Node<?> t = it.next();
                this.doUpdateProxy(t, list);
            }
        }
    }

    @Override
    public <VALUE_TYPE> void updateCache(Node<VALUE_TYPE> node, VALUE_TYPE newValue) {
        if (newValue instanceof AEmbeddedDTO || newValue instanceof ADTO) {
            ObjectWrapper<VALUE_TYPE> w = new ObjectWrapper<VALUE_TYPE>(newValue);
            Node<?> n = this.allNodes.get(w);
            if (n != null) {
                this.allNodes.remove(w);
                n.removeExistingValues();
                n.setValue(newValue, 0L);
            }
            this.allNodes.put(w, n);
        }
    }

    private <VALUE_TYPE> void doUpdateProxy(Node<VALUE_TYPE> node, List<Node<VALUE_TYPE>> list) {
        if (list == null) {
            list = new ArrayList<Node<VALUE_TYPE>>();
        }
        list.add(node);
        if (node instanceof ProxyNode) {
            ProxyNode prox = (ProxyNode)node;
            if (prox.getRefNode() == null && prox.getSource() != null) {
                ObjectWrapper w = new ObjectWrapper(prox.getSource());
                Node<?> n = this.allNodes.get(w);
                Object sourceValue = n.getValue();
                prox.setSource(sourceValue);
                prox.setRefNode(INodeCreator.getDefaultImpl().getNodeDirectly(prox.getSource()));
            }
        } else {
            Iterator<Node<?>> it = node.getChilds();
            while (it.hasNext()) {
                Node<?> t = it.next();
                if (list.contains(t)) continue;
                this.doUpdateProxy(t, list);
            }
        }
    }
}

