/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.node;

import ch.icit.pegasus.client.node.impls.Node;

public class LogicNodeOperation {
    private final Long timeStamp;
    public static final int CMD_SET_VALUE = 3;
    public static final int CMD_ADD_CHILD = 5;
    public static final int CMD_REMOVE_CHILD = 7;
    private final int selectedOperation;
    private final long groupId;
    private final Node currentNode;
    private final Node oldParent;
    private final Node newParent;
    private final Object newValue;
    private final Object oldValue;

    private LogicNodeOperation(int cmd, long groupId, Node currentNode, Node oldParent, Node newParent, Object newValue, Object oldValue) {
        this.selectedOperation = cmd;
        this.groupId = groupId;
        this.currentNode = currentNode;
        this.oldParent = oldParent;
        this.newParent = newParent;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.timeStamp = System.currentTimeMillis();
    }

    public Long getTimeStamp() {
        return this.timeStamp;
    }

    public int getSelectedOperation() {
        return this.selectedOperation;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public Node<?> getCurrentNode() {
        return this.currentNode;
    }

    public Node getOldParent() {
        return this.oldParent;
    }

    public Node getNewParent() {
        return this.newParent;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public static LogicNodeOperation getSetValueOperation(long groupId, Node currentNode, Object newValue, Object oldValue) {
        LogicNodeOperation op = new LogicNodeOperation(3, groupId, currentNode, null, null, newValue, oldValue);
        return op;
    }

    public static LogicNodeOperation getAddChildOperation(long groupId, Node currentNode, Node newParent, Node oldParent) {
        LogicNodeOperation op = new LogicNodeOperation(5, groupId, currentNode, oldParent, newParent, null, null);
        return op;
    }

    public static LogicNodeOperation getRemoveChildOperation(long groupId, Node currentNode, Node newParent, Node oldParent) {
        LogicNodeOperation op = new LogicNodeOperation(7, groupId, currentNode, oldParent, newParent, null, null);
        return op;
    }
}

