/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.search;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.general.IUniversal;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.search.SearchService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SearchResultIterator<T extends IUniversal>
implements Iterable<T> {
    final SearchService searchService;
    private ASearchConfiguration<T, ?> config;
    private Itr iterator;

    public SearchResultIterator(ASearchConfiguration<T, ?> config) throws ServiceException {
        this.config = config;
        this.searchService = EjbContextFactory.getInstance().getService(SearchService.class);
        this.config.setPageNumber(0);
        this.config.setNumResults(30);
        this.iterator = new Itr();
    }

    public SearchResultIterator(ASearchConfiguration<T, ?> config, int page) throws ServiceException {
        this.config = config;
        this.searchService = EjbContextFactory.getInstance().getService(SearchService.class);
        this.config.setPageNumber(page);
        this.config.setNumResults(30);
        this.iterator = new Itr();
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public T next() {
        return this.iterator.next();
    }

    public List<T> next(int number) {
        return this.iterator.next(number);
    }

    public long getSize() {
        return this.iterator.size;
    }

    class Itr
    implements Iterator<T> {
        private long position;
        private long size;
        private int pageOffset;
        private SearchResult<T> currentResult;

        Itr() {
            this.execSearch(false, true);
        }

        @Override
        public boolean hasNext() {
            return this.position < this.size && this.size != 0L;
        }

        private void execSearch(boolean incrementPage, boolean init) {
            if (incrementPage) {
                SearchResultIterator.this.config.setPageNumber(SearchResultIterator.this.config.getPageNumber() + 1);
            }
            try {
                if (SearchResultIterator.this.config instanceof ADtoSearchConfiguration) {
                    this.currentResult = SearchResultIterator.this.searchService.search((ADtoSearchConfiguration)SearchResultIterator.this.config);
                }
                if (init) {
                    this.currentResult.setPageNumber(Integer.valueOf(SearchResultIterator.this.config.getPageNumber()));
                }
                this.position = (long)this.currentResult.getPageNumber().intValue() * (long)this.currentResult.getPageSize().intValue();
                this.size = this.currentResult.getNumberOfResults();
                this.pageOffset = 0;
            }
            catch (ServiceException | IllegalArgumentException e) {
                new RuntimeException(e);
            }
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements");
            }
            if (this.currentResult.getResults().size() <= this.pageOffset) {
                this.execSearch(true, false);
            }
            ++this.position;
            if (this.currentResult.getResults().size() == 0) {
                return null;
            }
            return (IUniversal)this.currentResult.getResults().get(this.pageOffset++);
        }

        public List<T> next(int number) {
            ArrayList results = new ArrayList();
            for (int i = 0; i < number && this.hasNext(); ++i) {
                results.add(this.next());
            }
            return results;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

