/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.search.impls.remote;

import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.exception.SearchException;
import ch.icit.pegasus.server.core.dtos.search.ArticleChargeBatchSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import java.util.HashMap;

public class ArticleChargeBatchSearchAlgorithm
extends SearchAlgorithm<ArticleChargeBatchComplete> {
    @Override
    public ASearchConfiguration<ArticleChargeBatchComplete, ? extends Enum<?>> getSearchConfiguration() {
        return new ArticleChargeBatchSearchConfiguration();
    }

    @Override
    public ViewNode<SearchResult<ArticleChargeBatchComplete>> search(ASearchConfiguration<ArticleChargeBatchComplete, ? extends Enum<?>> conf) throws SearchException, ClientServerCallException {
        ViewNode<SearchResult<ArticleChargeBatchComplete>> search = super.search(conf);
        HashMap<BasicArticleLight, BasicArticleComplete> index = new HashMap<BasicArticleLight, BasicArticleComplete>();
        for (ArticleChargeBatchComplete result : ((SearchResult)search.getValue()).getResults()) {
            Long chargeId = result.getCharge() != null ? result.getCharge().getId() : result.getChargeId();
            ArticleChargeComplete charge = (ArticleChargeComplete)ServiceManagerRegistry.getService(SupplyServiceManager.class).getArticleCharge(new ArticleChargeReference(chargeId)).getValue();
            result.setCharge(charge);
            BasicArticleLight basicArticle = result.getCharge().getBasicArticle();
            if (index.containsKey(basicArticle)) {
                result.getCharge().setBasicArticle((BasicArticleLight)index.get(basicArticle));
                continue;
            }
            BasicArticleComplete artC = (BasicArticleComplete)ServiceManagerRegistry.getService(SupplyServiceManager.class).getBasicArticle(new BasicArticleReference(basicArticle.getId())).getValue();
            index.put(basicArticle, artC);
            result.getCharge().setBasicArticle((BasicArticleLight)artC);
        }
        return search;
    }
}

