/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.flight;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.AircraftServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.client.util.exception.ClientExceptionType;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.flightschedule.StowagePositionIdentifier;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.flight.AircraftService;
import ch.icit.pegasus.server.core.services.flight.StowingListService;
import java.util.Map;

public class AircraftServiceManagerImpl
implements AircraftServiceManager {
    @Override
    public ListWrapper<String> getGalleys(AircraftReference aircraftReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(AircraftService.class).getGalleys(aircraftReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, "Unable to replace Aircraft " + e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.ACTION);
        }
    }

    @Override
    public StowingListTemplateVariantLight switchAircraft(StowingListTemplateVariantReference value, AircraftLight newAircraft, Map<StowagePositionIdentifier, StowagePositionIdentifier> positionMapping) throws ClientActionOnServerException {
        try {
            return (StowingListTemplateVariantLight)EjbContextFactory.getInstance().getService(StowingListService.class).switchAircraftForTemplateVariant(new StowingListTemplateVariantReference(value.getId()), new AircraftReference(newAircraft.getId()), new MapWrapper(positionMapping)).getValue();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, "Unable to replace Aircraft " + e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.ACTION);
        }
    }

    @Override
    public OptionalWrapper<AircraftComplete> getAircraft(AircraftReference aircraft) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(AircraftService.class).getAircraft(aircraft);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e, ClientExceptionType.LOAD);
        }
    }

    @Override
    public OptionalWrapper<AircraftLight> createAircraft(AircraftLight aircraft) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(AircraftService.class).createAircraft(aircraft);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e, ClientExceptionType.CREATE);
        }
    }

    @Override
    public <D extends AircraftLight> OptionalWrapper<D> updateAircraft(D aircraft) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(AircraftService.class).updateAircraft(aircraft);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e, ClientExceptionType.UPDATE);
        }
    }

    @Override
    public OptionalWrapper<AircraftLight> getAircraftLight(AircraftReference dto) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(AircraftService.class).getAircraftLight(dto);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e, ClientExceptionType.LOAD);
        }
    }
}

