/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.flight;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.SalesOnBoardServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.ReturnMoneyComplete;
import ch.icit.pegasus.server.core.dtos.sob.CreditCardTransmissionComplete;
import ch.icit.pegasus.server.core.dtos.sob.CrewMemberLight;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.flight.SalesOnBoardService;

public class SalesOnBoardServiceManagerImpl
implements SalesOnBoardServiceManager {
    @Override
    public void checkoutFlightData(FlightReference value) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(SalesOnBoardService.class).checkoutFlightData(value);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public void exportFlightData(FlightReference flight) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(SalesOnBoardService.class).exportFlightData(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public void importFlightData(FlightReference flight) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(SalesOnBoardService.class).importFlightData(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CreditCardTransmissionComplete> create(CreditCardTransmissionComplete transmission) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SalesOnBoardService.class).create(transmission);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CreditCardTransmissionComplete> update(CreditCardTransmissionComplete transmission) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SalesOnBoardService.class).update(transmission);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void updateReturnMoney(FlightReference reference, ListWrapper<ReturnMoneyComplete> returnMoney) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(SalesOnBoardService.class).updateReturnMoney(reference, returnMoney);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void updateCrewMember(FlightReference reference, ListWrapper<CrewMemberLight> crewMember) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(SalesOnBoardService.class).updateCrewMember(reference, crewMember);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public ListWrapper<CrewMemberLight> getCrewMembers(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SalesOnBoardService.class).getCrewMembers(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public ListWrapper<ReturnMoneyComplete> getReturnMoneys(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SalesOnBoardService.class).getReturnMoneys(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightLight> saveSobIrregularityState(FlightReference flight, boolean hasIrregularity, String comment) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SalesOnBoardService.class).saveSobIrregularityState(flight, hasIrregularity, comment);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

