/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.incidentlog;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.incidentlog.IncidentLogServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogComplete;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogReference;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.incidentlog.IncidentLogService;

public class IncidentLogServiceManagerImpl
implements IncidentLogServiceManager {
    @Override
    public OptionalWrapper<IncidentLogComplete> getComplete(IncidentLogReference log) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(IncidentLogService.class).getComplete(log);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<IncidentLogComplete> update(IncidentLogComplete log) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(IncidentLogService.class).update(log);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<IncidentLogComplete> create(IncidentLogComplete log) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(IncidentLogService.class).create(log);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<IncidentLogSettingsComplete> getSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(IncidentLogService.class).getSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<IncidentLogSettingsComplete> updateSettings(IncidentLogSettingsComplete settings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(IncidentLogService.class).updateSettings(settings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void checkForReminders() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(IncidentLogService.class).checkForReminders();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createReportSheet(ReportFileComplete selectedReport, IncidentLogReference incident) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(IncidentLogService.class).createReportSheet(selectedReport, incident);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createDetailsReport(ListWrapper<IncidentLogReference> incidents) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(IncidentLogService.class).createDetailsReport(incidents);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

