/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.masterdata;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.file.SubReportFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AMasterDataComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PrintConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.ProductCategoryComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.masterdata.MasterDataService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MasterDataServiceManagerImpl
implements MasterDataServiceManager {
    public static Map<String, List<AMasterDataComplete>> cache = new HashMap<String, List<AMasterDataComplete>>();

    @Override
    public OptionalWrapper<PegasusFileComplete> createReport(Class<AMasterDataComplete> exportClass, String insertName) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).createReport(exportClass, insertName);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<ArticleCategoryComplete> getAllSuperArticleCategoriesWithDeleted() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).getAllSuperArticleCategoriesWithDeleted();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<ProductCategoryComplete> getAllSuperProductCategoriesWithDeleted() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).getAllSuperProductCategoriesWithDeleted();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<RecipeCategoryComplete> getAllSuperRecipeCategoriesWithDeleted() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).getAllSuperRecipeCategoriesWithDeleted();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public <T extends AMasterDataComplete> Node<List<T>> getAllSuperArticleCategoriesCached() throws ClientServerCallException {
        String name = ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(ArticleCategoryComplete.class);
        Node<List<Object>> n = NodeToolkit.getAffixNamed(name);
        if (n == null) {
            List data = cache.get(name);
            if (data == null) {
                data = this.getAllSuperArticleCategories().getList();
            }
            n = INodeCreator.getDefaultImpl().createNodes(data, false);
            n.setName(name);
            NodeToolkit.addAffix(n);
        }
        return n;
    }

    @Override
    public <T extends AMasterDataComplete> Node<List<T>> getAllSuperArticleCategoriesUnCached() throws ClientServerCallException {
        String name = ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(ArticleCategoryComplete.class);
        Node<List<T>> n = null;
        NodeToolkit.removeAffixNamed(name);
        n = INodeCreator.getDefaultImpl().createNodes(this.getAllSuperArticleCategories().getList(), false);
        n.setName(name);
        NodeToolkit.addAffix(n);
        return n;
    }

    @Override
    public <T extends AMasterDataComplete> Node<List<T>> getAllCached(Class<T> type) throws ClientServerCallException {
        return this.getAllCached(type, false);
    }

    @Override
    public <T extends AMasterDataComplete> Node<List<T>> getAllCached(Class<T> type, boolean includeDeleted) throws ClientServerCallException {
        String name = ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(type);
        Node<List<Object>> n = NodeToolkit.getAffixNamed(name);
        if (n == null) {
            List data = cache.get(name);
            if (data == null) {
                data = this.getAll(type, includeDeleted).getList();
                cache.put(name, data);
            }
            n = INodeCreator.getDefaultImpl().createNodes(data, false);
            n.setName(name);
            NodeToolkit.addAffix(n);
        }
        return n;
    }

    @Override
    public Node<List<RecipeCategoryComplete>> getAllSuperRecipeCategoriesCached() throws ClientServerCallException {
        Node<List<Object>> n = NodeToolkit.getAffixList(RecipeCategoryComplete.class);
        if (n == null) {
            String name = ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(RecipeCategoryComplete.class);
            List data = cache.get(name);
            if (data == null) {
                data = this.getAllSuperRecipeCategories().getList();
            }
            Node nn = INodeCreator.getDefaultImpl().createNodes(data, false);
            n = nn;
            n.setName(name);
            NodeToolkit.addAffix(n);
        }
        return n;
    }

    @Override
    public Node<List<RecipeCategoryComplete>> getAllSuperRecipeCategoriesUnCached() throws ClientServerCallException {
        String name = ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(RecipeCategoryComplete.class);
        NodeToolkit.removeAffixNamed(name);
        Node<List<RecipeCategoryComplete>> n = null;
        List l = this.getAllSuperRecipeCategories().getList();
        n = INodeCreator.getDefaultImpl().createNodes(l, false);
        n.setName(name);
        NodeToolkit.addAffix(n);
        return n;
    }

    @Override
    public Node<List<ProductCategoryComplete>> getAllSuperProductCategoriesCached() throws ClientServerCallException {
        Node<List<Object>> n = NodeToolkit.getAffixList(ProductCategoryComplete.class);
        if (n == null) {
            String name = ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(ProductCategoryComplete.class);
            List data = cache.get(name);
            if (data == null) {
                data = this.getAllSuperProductCategories().getList();
            }
            Node nn = INodeCreator.getDefaultImpl().createNodes(data, false);
            n = nn;
            n.setName(name);
            NodeToolkit.addAffix(n);
        }
        return n;
    }

    @Override
    public Node<List<CustomerLight>> getAllCustomersCached() throws ClientServerCallException {
        Node<List<CustomerLight>> n = NodeToolkit.getAffixList(CustomerLight.class);
        if (n == null) {
            String name = ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(CustomerLight.class);
            List data = cache.get(name);
            if (data == null) {
                data = ServiceManagerRegistry.getService(SupplyServiceManager.class).getAllCustomersLight().getList();
            }
            Node<List<AMasterDataComplete>> nn = INodeCreator.getDefaultImpl().createNodes(data, false);
            n = nn;
            n.setName(name);
            NodeToolkit.addAffix(n);
        }
        return n;
    }

    @Override
    public Node<List<ProductCategoryComplete>> getAllSuperProductCategoriesUnCached() throws ClientServerCallException {
        String name = ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(ProductCategoryComplete.class);
        NodeToolkit.removeAffixNamed(name);
        Node<List<ProductCategoryComplete>> n = null;
        List l = this.getAllSuperProductCategories().getList();
        n = INodeCreator.getDefaultImpl().createNodes(l, false);
        n.setName(name);
        NodeToolkit.addAffix(n);
        return n;
    }

    @Override
    public ListWrapper<PrintConfigurationComplete> getPrintConfigurationForPrinterName(String name) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).getPrintConfigurationForPrinterName(name);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<ReportConfigurationComplete> getReportConfiguration(ReportTypeE type) throws ClientGetFromServerException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).getReportConfiguration(type);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<ArticleCategoryComplete> getAllSuperArticleCategories() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).getAllSuperArticleCategories();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<ProductCategoryComplete> getAllSuperProductCategories() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).getAllSuperProductCategories();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<RecipeCategoryComplete> getAllSuperRecipeCategories() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).getAllSuperRecipeCategories();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ReportFileComplete getDefaultReportStylesheet(ReportTypeE type) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).getDefaultReportStylesheet(type);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<ReportFileComplete> getReportStylesheets(ReportTypeE type) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).getReportStylesheets(type);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<SubReportFileComplete> getSubReportStylesheets() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).getSubReportStylesheets();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public <T extends AMasterDataComplete> ListWrapper<T> getAll(Class<T> type, boolean includeDeleted) throws ClientServerCallException {
        try {
            ListWrapper all = EjbContextFactory.getInstance().getService(MasterDataService.class).getAll(type, includeDeleted);
            return all;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public <T extends AMasterDataComplete> OptionalWrapper<T> update(T dto) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).update(dto);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public <T extends AMasterDataComplete> OptionalWrapper<T> create(T dto) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).create(dto);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public <T extends AMasterDataComplete> OptionalWrapper<T> delete(T dto) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).delete(dto);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public <T extends AMasterDataComplete> OptionalWrapper<T> restore(T dto) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MasterDataService.class).restore(dto);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public <T extends AMasterDataComplete> Node<List<T>> getAllUnCached(Class<T> type, boolean includeDeleted) throws ClientServerCallException {
        String name = ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(type);
        NodeToolkit.removeAffixNamed(name);
        Node<List<T>> n = null;
        n = INodeCreator.getDefaultImpl().createNodes(this.getAll(type, includeDeleted).getList(), false);
        n.setName(name);
        NodeToolkit.addAffix(n);
        return n;
    }

    @Override
    public <T extends AMasterDataComplete> Node<List<T>> getAllUnCached(Class<T> type) throws ClientServerCallException {
        return this.getAllUnCached(type, false);
    }
}

