/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.notification;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.notification.ChangeNotificationServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientExceptionType;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationComplete;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationLight;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.notification.ChangeNotificationService;

public class ChangeNotificationServiceManagerImpl
implements ChangeNotificationServiceManager {
    @Override
    public OptionalWrapper<ChangeNotificationComplete> createManualChangeNotification(ChangeNotificationComplete changeNotification) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ChangeNotificationService.class).createManualChangeNotification(changeNotification);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e, ClientExceptionType.CREATE);
        }
    }

    @Override
    public OptionalWrapper<ChangeNotificationLight> updateChangeNotification(ChangeNotificationLight changeNotification) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ChangeNotificationService.class).updateChangeNotification(changeNotification);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e, ClientExceptionType.UPDATE);
        }
    }

    @Override
    public OptionalWrapper<ChangeNotificationLight> getChangeNotificationLight(ChangeNotificationReference changeNotificationReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ChangeNotificationService.class).getChangeNotificationLight(changeNotificationReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e, ClientExceptionType.LOAD);
        }
    }

    public OptionalWrapper<ChangeNotificationComplete> getChangeNotificationComplete(ChangeNotificationReference changeNotificationReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ChangeNotificationService.class).getChangeNotificationComplete(changeNotificationReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e, ClientExceptionType.LOAD);
        }
    }

    @Override
    public void deleteChangeNotification(ChangeNotificationReference changeNotificationReference) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(ChangeNotificationService.class).deleteChangeNotification(changeNotificationReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e, ClientExceptionType.LOAD);
        }
    }

    @Override
    public OptionalWrapper<ChangeNotificationLight> markChangeNotificationAsProcessedByManager(ChangeNotificationReference changeNotificationReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ChangeNotificationService.class).markChangeNotificationAsProcessedByManager(changeNotificationReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e, ClientExceptionType.ACTION);
        }
    }

    @Override
    public OptionalWrapper<ChangeNotificationLight> invertState(ChangeNotificationReference changeNotificationReference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ChangeNotificationService.class).invertState(changeNotificationReference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e, ClientExceptionType.ACTION);
        }
    }
}

