/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.recipe;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.recipe.RecipeServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.services.recipe.RecipeService;

public class RecipeServiceManagerImpl
implements RecipeServiceManager {
    @Override
    public OptionalWrapper<RecipeComplete> createRecipe(RecipeComplete recipe) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeService.class).createRecipe(recipe);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RecipeComplete> updateRecipe(RecipeComplete recipe, TimestampWrapper validity) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeService.class).updateRecipe(recipe, validity);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RecipeComplete> getRecipe(RecipeReference recipe) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeService.class).getRecipe(recipe);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RecipeVariantComplete> getRecipeVariant(RecipeVariantReference recipeVariant) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeService.class).getRecipeVariant(recipeVariant);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<RecipeVariantLight> getRecipeVariants(ListWrapper<RecipeVariantReference> variants) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeService.class).getRecipeVariants(variants);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RecipeVariantComplete> resolveVariant(RecipeReference recipe, TimestampWrapper validity) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RecipeService.class).resolveVariant(recipe, validity);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

