/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.reorderlevel;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.interfaces.reorderlevel.ReorderLevelServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.client.util.exception.ClientExceptionType;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelComplete;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelLight;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.reorderlevel.ReorderLevelService;

public class ReorderLevelServiceManagerImpl
implements ReorderLevelServiceManager {
    @Override
    public OptionalWrapper<ReorderLevelComplete> createReorderLevel(ReorderLevelComplete reorderLevel) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ReorderLevelService.class).createReorderLevel(reorderLevel);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.CREATE);
        }
    }

    @Override
    public OptionalWrapper<ReorderLevelComplete> updateReorderLevel(ReorderLevelComplete reorderLevel) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ReorderLevelService.class).updateReorderLevel(reorderLevel);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.UPDATE);
        }
    }

    @Override
    public OptionalWrapper<ReorderLevelComplete> getReorderLevel(ReorderLevelReference reorderLevel) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ReorderLevelService.class).getReorderLevel(reorderLevel);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.LOAD);
        }
    }

    @Override
    public OptionalWrapper<ReorderLevelComplete> calculate(ReorderLevelLight reorderLevel) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ReorderLevelService.class).calculate(reorderLevel);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.LOAD);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createDetailsExport(ListWrapper<ReorderLevelReference> items) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ReorderLevelService.class).createDetailsExport(items);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.LOAD);
        }
    }
}

