/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.report;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.InvoiceReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceReference;
import ch.icit.pegasus.server.core.dtos.report.InvoiceReportConfiguration;
import ch.icit.pegasus.server.core.dtos.search.InvoiceSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.report.InvoiceReportService;

public class InvoiceReportServiceManagerImpl
implements InvoiceReportServiceManager {
    @Override
    public OptionalWrapper<PegasusFileComplete> createInvoiceMonthlySummary(InvoiceSearchConfiguration config, boolean excludeVat) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceReportService.class).createInvoiceMonthlySummary(config, excludeVat);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createInvoiceCostAssignmentReport(InvoiceSearchConfiguration invoiceSearch) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceReportService.class).createInvoiceCostAssignmentReport(invoiceSearch);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createInvoiceExcelExport(InvoiceReference invoice, boolean useProductsInsteadOfFixMeals, boolean includeZeroPriceItems) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceReportService.class).createInvoiceExcelExport(invoice, useProductsInsteadOfFixMeals, includeZeroPriceItems);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    public OptionalWrapper<PegasusFileComplete> createFlightInvoiceOverviewExport(InvoiceReference invoice, boolean includeZeroPriceItems) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceReportService.class).createFlightInvoiceOverviewExport(invoice, includeZeroPriceItems);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createInvoiceReport(InvoiceReportConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceReportService.class).createInvoiceReport(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createInvoiceExport(InvoiceReference invoice, boolean isFinal, boolean showProductsInsteadOfFixPrice, boolean sortByMealPlan, boolean sortByName, boolean sortByNumber, boolean includeNullValues, boolean includePax, ListWrapper<String> warningsCallBack, boolean showCompleteConversion) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceReportService.class).createInvoiceExport(invoice, isFinal, showProductsInsteadOfFixPrice, sortByMealPlan, sortByName, sortByNumber, includeNullValues, includePax, warningsCallBack, showCompleteConversion);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createInvoiceSummary(InvoiceSearchConfiguration config, boolean groupCustomers) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InvoiceReportService.class).createInvoiceSummary(config, groupCustomers);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

