/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.report;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.LabelReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.client.util.exception.ClientCreateReportException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.DeliverableComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.AlaCarteMealLabelComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.ILabelComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.ItemLabelComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.SpecialMealLabelComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.StowingListReportConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.LabelWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TrackableItemWrapper;
import ch.icit.pegasus.server.core.services.report.LabelReportService;
import ch.icit.pegasus.server.core.util.ServiceReturnWithMessage;
import ch.icit.utils.GTINCategory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LabelReportServiceManagerImpl
implements LabelReportServiceManager {
    @Override
    public void printScanningReport(FlightReference ref) throws ClientGetFromServerException {
        throw new ClientGetFromServerException("Scanning Report is not supported yet");
    }

    @Override
    public List<AlaCarteMealLabelComplete> getAlaCarteMealLabels(FlightReference flight, boolean showDifferenceOnly, List<FlightLegComplete> legs, CabinClassComplete cabinClass) throws ClientServerCallException {
        List b = this.getAlaCarteMealLabels(new FlightReference(flight.getId()), showDifferenceOnly, cabinClass).getList();
        if (legs != null) {
            Iterator it = b.iterator();
            while (it.hasNext()) {
                AlaCarteMealLabelComplete l = (AlaCarteMealLabelComplete)it.next();
                if (legs.contains(l.getMeal().getLeg())) continue;
                it.remove();
            }
        }
        return b;
    }

    @Override
    public ListWrapper<AlaCarteMealLabelComplete> getAlaCarteMealLabels(FlightReference flight, boolean onlyChanged, CabinClassComplete cabinClass) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(LabelReportService.class).getAlaCarteMealLabels(flight, onlyChanged, cabinClass);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientCreateReportException(e);
        }
    }

    @Override
    public ListWrapper<PegasusFileComplete> createItemLabels(FlightReference flight, ListWrapper<ItemLabelComplete> labels, ReportingOutputFormatE format) throws ClientCreateReportException {
        try {
            EjbContextFactory instance = EjbContextFactory.getInstance();
            LabelReportService service = instance.getService(LabelReportService.class);
            return service.createItemLabels(flight, labels, format);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientCreateReportException(e);
        }
    }

    @Override
    public ListWrapper<PegasusFileComplete> createAlaCarteMealLabels(FlightReference flight, ListWrapper<AlaCarteMealLabelComplete> labels, ReportingOutputFormatE format) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(LabelReportService.class).createAlaCarteMealLabels(flight, labels, format);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientCreateReportException(e);
        }
    }

    @Override
    public ListWrapper<PegasusFileComplete> createSpecialMealLabels(FlightReference flight, ListWrapper<SpecialMealLabelComplete> labels, ReportingOutputFormatE format) throws ClientCreateReportException {
        try {
            return EjbContextFactory.getInstance().getService(LabelReportService.class).createSpecialMealLabels(flight, labels, format);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientCreateReportException(e);
        }
    }

    @Override
    public byte[] createLabelPreview(LabelWrapper label) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(LabelReportService.class).createLabelPreview(label);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public byte[] createLabelPreviewForFlightWithWarnings(TrackableItemWrapper item, ListWrapper<DeliverableComplete> associatedDeliverables, FlightScheduleReference flight, ListWrapper<String> warnings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(LabelReportService.class).createLabelPreviewForFlightWithWarnings(item, associatedDeliverables, flight, warnings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public byte[] createLabelPreviewForSL(TrackableItemWrapper item, ListWrapper<DeliverableComplete> associatedDeliverables, StowingListTemplateReference stw, ListWrapper<String> warnings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(LabelReportService.class).createLabelPreviewForSL(item, associatedDeliverables, stw, warnings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public byte[] createLabelPreviewForFlight(TrackableItemWrapper item, ListWrapper<DeliverableComplete> associatedDeliverables, FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(LabelReportService.class).createLabelPreviewForFlight(item, associatedDeliverables, flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public ServiceReturnWithMessage<ListWrapper<ItemLabelComplete>> getItemLabels(FlightReference flight, String name, CostCenterComplete costCenter, ColorComplete color, ReportFileComplete label, CabinClassComplete cabinClass, boolean onlyChanged, boolean contents) throws ClientCreateReportException {
        if (costCenter == null) {
            costCenter = new InternalCostCenterComplete();
        }
        if (color == null) {
            color = new ColorComplete();
        }
        if (label == null) {
            label = new ReportFileComplete();
        }
        if (cabinClass == null) {
            cabinClass = new CabinClassComplete();
        }
        try {
            return EjbContextFactory.getInstance().getService(LabelReportService.class).getItemLabels(flight, name, costCenter, color, label, cabinClass, onlyChanged, contents);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientCreateReportException(e);
        }
    }

    @Override
    public List<ItemLabelComplete> getItemLabels(FlightReference flight, CostCenterComplete costCenter, ColorComplete color, ReportFileComplete label, CabinClassComplete cabinClass, List<FlightLegComplete> legs, boolean onlyChanged, boolean contents) throws ClientCreateReportException {
        ServiceReturnWithMessage<ListWrapper<ItemLabelComplete>> all = this.getItemLabels(flight, "", costCenter, color, label, cabinClass, onlyChanged, contents);
        List b = ((ListWrapper)all.getObject()).getList();
        if (legs != null) {
            Iterator it = b.iterator();
            while (it.hasNext()) {
                ItemLabelComplete l = (ItemLabelComplete)it.next();
                if (legs.contains(l.getLeg())) continue;
                it.remove();
            }
        }
        return b;
    }

    @Override
    public ListWrapper<SpecialMealLabelComplete> getSpecialMealLabels(FlightReference flight, boolean onlyChanged, CabinClassComplete cabinClass) throws ClientCreateReportException {
        try {
            return EjbContextFactory.getInstance().getService(LabelReportService.class).getSpecialMealLabels(flight, onlyChanged, cabinClass);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientCreateReportException(e);
        }
    }

    @Override
    public List<SpecialMealLabelComplete> getSpecialMealLabels(FlightReference flight, boolean showDifferenceOnly, List<FlightLegComplete> legs, CabinClassComplete cabinClass) throws ClientCreateReportException {
        List b = this.getSpecialMealLabels(new FlightReference(flight.getId()), showDifferenceOnly, cabinClass).getList();
        if (legs != null) {
            Iterator it = b.iterator();
            while (it.hasNext()) {
                SpecialMealLabelComplete l = (SpecialMealLabelComplete)it.next();
                if (legs.contains(l.getMeal().getLeg())) continue;
                it.remove();
            }
        }
        return b;
    }

    @Override
    public ListWrapper<ILabelComplete> incrementPrintCount(ListWrapper<ILabelComplete> labels) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(LabelReportService.class).incrementPrintCount(labels);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public GTINCategory getCategory(String barcode) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(LabelReportService.class).getCategory(barcode);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ServiceReturnWithMessage<List<PegasusFileComplete>> printFlightLabel(StowingListReportConfiguration<FlightReference, FlightLegComplete> s, boolean isSPML, boolean showDifferenceOnly, List<FlightLegComplete> legs, boolean labelWithContents) throws ClientCreateReportException {
        Object o;
        ArrayList<Object> a;
        ArrayList incrementLabels;
        ArrayList files = new ArrayList();
        List warnings = null;
        List regularLabels = null;
        List<SpecialMealLabelComplete> spmlLabels = null;
        if (s.getRegularLabel().booleanValue()) {
            try {
                ServiceReturnWithMessage<ListWrapper<ItemLabelComplete>> o2 = this.getItemLabels((FlightReference)s.getDto(), "", s.getDepartment(), s.getLabelColor(), new ReportFileComplete(), new CabinClassComplete(), showDifferenceOnly, labelWithContents);
                incrementLabels = new ArrayList(((ListWrapper)o2.getObject()).getList());
                this.incrementPrintCount((ListWrapper<ILabelComplete>)new ListWrapper(incrementLabels));
                regularLabels = ((ListWrapper)o2.getObject()).getList();
                warnings = o2.getMessage();
            }
            catch (ClientCreateReportException e) {
                ErrorSupport.fireException(Thread.currentThread(), (Exception)((Object)e), "Unable to get Item Label: " + e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
                throw e;
            }
            catch (ClientServerCallException e) {
                ErrorSupport.fireException(Thread.currentThread(), (Exception)((Object)e), "Unable to get Item Label: " + e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
                throw new ClientCreateReportException((Exception)((Object)e));
            }
        }
        if (s.getSpmlLabel().booleanValue()) {
            try {
                List<SpecialMealLabelComplete> o2 = this.getSpecialMealLabels((FlightReference)s.getDto(), showDifferenceOnly, legs, null);
                incrementLabels = new ArrayList<SpecialMealLabelComplete>(o2);
                this.incrementPrintCount((ListWrapper<ILabelComplete>)new ListWrapper((List)incrementLabels));
                spmlLabels = o2;
            }
            catch (ClientCreateReportException e) {
                ErrorSupport.fireException(Thread.currentThread(), (Exception)((Object)e), "Unable to get SPML Labels: " + e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
                throw e;
            }
            catch (ClientServerCallException e) {
                ErrorSupport.fireException(Thread.currentThread(), (Exception)((Object)e), "Unable to get SPML Labels: " + e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
                throw new ClientCreateReportException((Exception)((Object)e));
            }
        }
        if (s.getRegularLabel().booleanValue() && regularLabels != null) {
            a = new ArrayList<Object>();
            for (Object e : regularLabels) {
                if (!(e instanceof ItemLabelComplete)) continue;
                ((ItemLabelComplete)e).setNormalColor(((ItemLabelComplete)e).getHandlingLog().getItem().getLabelConfiguration().getLabelColor());
                a.add((ItemLabelComplete)e);
            }
            o = ServiceManagerRegistry.getService(LabelReportServiceManager.class).createItemLabels((FlightReference)s.getDto(), (ListWrapper<ItemLabelComplete>)new ListWrapper(a), ReportingOutputFormatE.PDF).getList();
            files.addAll(o);
        }
        if (s.getSpmlLabel().booleanValue() && spmlLabels != null) {
            a = new ArrayList();
            for (Object e : spmlLabels) {
                if (!(e instanceof SpecialMealLabelComplete)) continue;
                a.add((SpecialMealLabelComplete)e);
            }
            o = ServiceManagerRegistry.getService(LabelReportServiceManager.class).createSpecialMealLabels((FlightReference)s.getDto(), (ListWrapper<SpecialMealLabelComplete>)new ListWrapper(a), ReportingOutputFormatE.PDF).getList();
            files.addAll(o);
        }
        ServiceReturnWithMessage ret = new ServiceReturnWithMessage(files, warnings);
        return ret;
    }

    @Override
    public PegasusFileComplete createLogoutLabelSheet(ReportFileComplete selectedReport) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(LabelReportService.class).createLogoutLabelSheet(selectedReport);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }
}

