/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.restaurant;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.restaurant.RestaurantServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.restaurant.RestaurantService;

public class RestaurantServiceManagerImpl
implements RestaurantServiceManager {
    @Override
    public OptionalWrapper<RestaurantComplete> create(RestaurantComplete restaurant) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RestaurantService.class).create(restaurant);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RestaurantComplete> update(RestaurantComplete restaurant) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RestaurantService.class).update(restaurant);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RestaurantComplete> getRestaurant(RestaurantComplete restaurant) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RestaurantService.class).getRestaurant(restaurant);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

