/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.safetystock;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.interfaces.safetystock.SafetyStockServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.client.util.exception.ClientExceptionType;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockComplete;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockLight;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.safetystock.SafetyStockService;

public class SafetyStockServiceManagerImpl
implements SafetyStockServiceManager {
    @Override
    public OptionalWrapper<SafetyStockComplete> createSafetyStock(SafetyStockComplete safetyStock) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SafetyStockService.class).createSafetyStock(safetyStock);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.CREATE);
        }
    }

    @Override
    public OptionalWrapper<SafetyStockComplete> updateSafetyStock(SafetyStockComplete safetyStock) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SafetyStockService.class).updateSafetyStock(safetyStock);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.UPDATE);
        }
    }

    @Override
    public OptionalWrapper<SafetyStockComplete> getSafetyStock(SafetyStockReference safetyStock) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SafetyStockService.class).getSafetyStock(safetyStock);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.LOAD);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createDetailsExport(ListWrapper<SafetyStockReference> items) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SafetyStockService.class).createDetailsExport(items);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.LOAD);
        }
    }

    @Override
    public OptionalWrapper<SafetyStockComplete> calculate(SafetyStockLight safetyStock) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SafetyStockService.class).calculate(safetyStock);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage());
            throw new ClientActionOnServerException(e, ClientExceptionType.LOAD);
        }
    }
}

