/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.sageimport;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.sageimport.SageImportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientExceptionType;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.sage.SageImportComplete;
import ch.icit.pegasus.server.core.dtos.sage.SageImportReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.sageimport.SageImportService;

public class SageImportServiceManagerImpl
implements SageImportServiceManager {
    @Override
    public void resolveSageImport(ListWrapper<SageImportReference> sageImports) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getStatelessService(SageImportService.class).resolveSageImport(sageImports);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e, ClientExceptionType.UPDATE);
        }
    }

    @Override
    public OptionalWrapper<SageImportComplete> getSageImport(SageImportReference sageImport) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(SageImportService.class).getSageImport(sageImport);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e, ClientExceptionType.UPDATE);
        }
    }

    @Override
    public OptionalWrapper<SageImportComplete> createSageImport(SageImportComplete sageImport) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(SageImportService.class).createSageImport(sageImport);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e, ClientExceptionType.UPDATE);
        }
    }

    @Override
    public OptionalWrapper<SageImportComplete> updateSageImport(SageImportComplete sageImport) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatelessService(SageImportService.class).updateSageImport(sageImport);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e, ClientExceptionType.UPDATE);
        }
    }
}

