/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.ArticleStockSwapServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportComplete;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportLight;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.supply.ArticleStockSwapService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArticleStockSwapServiceManagerImpl
implements ArticleStockSwapServiceManager {
    private static Logger log = LoggerFactory.getLogger(ArticleStockSwapServiceManagerImpl.class);

    @Override
    public OptionalWrapper<ArticleStockSwapDataImportComplete> resolve(ArticleStockSwapDataImportReference data) throws ClientSaveOnServerException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleStockSwapService.class).resolve(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ArticleStockSwapDataImportComplete> createArticleStockSwapData(ArticleStockSwapDataImportComplete data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleStockSwapService.class).createArticleStockSwapData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getArticleStockSwapReport(ListWrapper<ArticleStockSwapDataImportReference> s) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleStockSwapService.class).getArticleStockSwapReport(s);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ArticleStockSwapDataImportComplete> getArticleStockSwapData(ArticleStockSwapDataImportLight data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleStockSwapService.class).getArticleStockSwapData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ArticleStockSwapDataImportComplete> updateArticleStockSwapData(ArticleStockSwapDataImportComplete data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleStockSwapService.class).updateArticleStockSwapData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ArticleStockSwapDataImportComplete> performArticleStockSwapData(ArticleStockSwapDataImportReference data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleStockSwapService.class).performArticleStockSwapData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void deleteArticleStockSwapData(ArticleStockSwapDataImportReference data) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(ArticleStockSwapService.class).deleteArticleStockSwapData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ArticleStockSwapDataImportComplete> uploadFileStockArticleStockSwapData(PegasusFileComplete fileName, ArticleStockSwapDataImportReference data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleStockSwapService.class).uploadFileStockArticleStockSwapData(fileName, data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ArticleStockSwapDataImportComplete> performConvertedQuantityArticleStockSwapData(PegasusFileComplete fileName, ArticleStockSwapDataImportReference data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleStockSwapService.class).performConvertedQuantityArticleStockSwapData(fileName, data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

