/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.AutoReportingServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.dataexchange.AutoReportingSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.supply.AutoReportingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoReportingServiceManagerImpl
implements AutoReportingServiceManager {
    private static Logger log = LoggerFactory.getLogger(AutoReportingServiceManagerImpl.class);

    @Override
    public OptionalWrapper<AutoReportingSettingsComplete> getAutoReportingSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(AutoReportingService.class).getAutoReportingSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    public void sendAutoReportingData() throws ServiceException {
        try {
            EjbContextFactory.getInstance().getService(AutoReportingService.class).sendAutoReportingData();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

