/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.ESpecsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.dataexchange.ESpecsSettingsComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.report.especs.ESpecsConfig;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.supply.ESpecsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESpecsServiceManagerImpl
implements ESpecsServiceManager {
    private static Logger log = LoggerFactory.getLogger(ESpecsServiceManagerImpl.class);

    @Override
    public MapWrapper<String, PegasusFileComplete> sendESpecsData(ESpecsConfig config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ESpecsService.class).sendESpecsData(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<String, PegasusFileComplete> readESpecsData(ESpecsConfig config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ESpecsService.class).readESpecsData(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Node<ESpecsSettingsComplete> getEspescSettingsCached() {
        Node<ESpecsSettingsComplete> node = NodeToolkit.getAffixClass(ESpecsSettingsComplete.class);
        if (node == null) {
            ESpecsSettingsComplete es = (ESpecsSettingsComplete)this.getEspecsSettings().getValue();
            node = INodeCreator.getDefaultImpl().getNode4DTO(es, false, false);
            node.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(ESpecsSettingsComplete.class));
            NodeToolkit.addAffix(node);
        }
        return node;
    }

    @Override
    public OptionalWrapper<ESpecsSettingsComplete> getEspecsSettings() {
        try {
            return EjbContextFactory.getInstance().getService(ESpecsService.class).getEspecsSettings();
        }
        catch (Exception e) {
            log.error("EspecsSettings-Config");
            return null;
        }
    }
}

