/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.FlightTransactionGeneratorServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.dataexchange.FlightTransactionGeneratorSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.supply.FlightTransactionGeneratorService;

public class FlightTransactionGeneratorServiceManagerImpl
implements FlightTransactionGeneratorServiceManager {
    @Override
    public Node<FlightTransactionGeneratorSettingsComplete> getSettingsCached() throws ClientServerCallException {
        Node<FlightTransactionGeneratorSettingsComplete> settings = NodeToolkit.getAffixClass(FlightTransactionGeneratorSettingsComplete.class);
        if (settings != null) {
            INodeCreator.getDefaultImpl().addToAllNodes(settings);
        } else {
            FlightTransactionGeneratorSettingsComplete dto = (FlightTransactionGeneratorSettingsComplete)this.getSettings().getValue();
            settings = INodeCreator.getDefaultImpl().getNode4DTO(dto, false, false);
            settings.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(FlightTransactionGeneratorSettingsComplete.class));
            NodeToolkit.addAffix(settings);
        }
        return settings;
    }

    @Override
    public OptionalWrapper<FlightTransactionGeneratorSettingsComplete> getSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(FlightTransactionGeneratorService.class).getSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void createFlightTransactions() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(FlightTransactionGeneratorService.class).createFlightTransactions();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void createStatisticForFlightTransactions() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(FlightTransactionGeneratorService.class).createStatisticForFlightTransactions();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

