/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.InventoryServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientCreateReportException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryStoreComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionReference;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.supply.InventoryService;

public class InventoryServiceManagerImpl
implements InventoryServiceManager {
    @Override
    public void revert(InventoryReference inventory, StoreReference storeReference, Boolean revertAsCounting) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(InventoryService.class).revert(inventory, storeReference, revertAsCounting);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<InventoryComplete> createInventory(InventoryComplete inventory) throws ClientServerCallException {
        for (InventoryStoreComplete store : inventory.getStores()) {
            if (store.getStore() == null) continue;
            store.setStore(new StoreReference(store.getStore().getId()));
        }
        try {
            OptionalWrapper inv = EjbContextFactory.getInstance().getService(InventoryService.class).createInventory(inventory);
            this.reloadStores((InventoryComplete)inv.getValue());
            return inv;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<InventoryComplete> updateInventory(InventoryComplete inventory) throws ClientServerCallException {
        for (InventoryStoreComplete store : inventory.getStores()) {
            if (store.getStore() == null) continue;
            store.setStore(new StoreReference(store.getStore().getId()));
        }
        try {
            OptionalWrapper inv = EjbContextFactory.getInstance().getService(InventoryService.class).updateInventory(inventory);
            this.reloadStores((InventoryComplete)inv.getValue());
            return inv;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<InventoryComplete> get(InventoryReference inventory) throws ClientServerCallException {
        try {
            OptionalWrapper inv = EjbContextFactory.getInstance().getService(InventoryService.class).get(inventory);
            this.reloadStores((InventoryComplete)inv.getValue());
            return inv;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<ArticleChargeBatchComplete> getRemainingArticleBatches(StoreLight store, InventoryLight inventory) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryService.class).getRemainingArticleBatches(store, inventory);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<InventoryComplete> startFullInventory(InventoryLight inventory) throws ClientServerCallException {
        try {
            OptionalWrapper inv = EjbContextFactory.getInstance().getService(InventoryService.class).startFullInventory(inventory);
            this.reloadStores((InventoryComplete)inv.getValue());
            return inv;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    private void reloadStores(InventoryComplete inv) throws ClientServerCallException {
        for (InventoryStoreComplete store : inv.getStores()) {
            if (store.getStore() == null) continue;
            StoreLight storeLight = (StoreLight)ServiceManagerRegistry.getService(StoreServiceManager.class).getStoreLightByReference(store.getStore()).getValue();
            store.setStore((StoreReference)storeLight);
        }
    }

    @Override
    public OptionalWrapper<InventoryComplete> closeFullInventory(InventoryLight inventory) throws ClientServerCallException {
        try {
            OptionalWrapper inv = EjbContextFactory.getInstance().getService(InventoryService.class).closeFullInventory(inventory);
            this.reloadStores((InventoryComplete)inv.getValue());
            return inv;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StoreLight> startStoreInventory(InventoryReference inventory, StoreReference store) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryService.class).startStoreInventory(inventory, store);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StoreLight> closeStoreInventory(InventoryLight inventory, StoreLight store) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryService.class).closeStoreInventory(inventory, store);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<InventoryComplete> startInventory(InventoryLight inventory) throws ClientServerCallException {
        try {
            OptionalWrapper inv = EjbContextFactory.getInstance().getService(InventoryService.class).startInventory(inventory);
            this.reloadStores((InventoryComplete)inv.getValue());
            return inv;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<InventoryComplete> closeInventory(InventoryLight inventory) throws ClientServerCallException {
        try {
            OptionalWrapper inv = EjbContextFactory.getInstance().getService(InventoryService.class).closeInventory(inventory);
            this.reloadStores((InventoryComplete)inv.getValue());
            return inv;
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<StockTransactionComplete> getInventoryTransactions(InventoryReference inventory, boolean showDuplicates) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryService.class).getInventoryTransactions(inventory, showDuplicates);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void printRemainingInventoryBatches(StoreReference store, InventoryReference inventory) throws ClientCreateReportException {
        throw new ClientCreateReportException("Not yet Implemented", null);
    }

    public OptionalWrapper<InventoryTransitionComplete> createInventoryTransition(InventoryTransitionComplete inventory) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryService.class).createInventoryTransition(inventory);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public OptionalWrapper<InventoryTransitionComplete> updateInventoryTransition(InventoryTransitionComplete inventory) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryService.class).updateInventoryTransition(inventory);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public OptionalWrapper<InventoryTransitionComplete> getByTransition(InventoryTransitionReference inventory) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(InventoryService.class).getByTransition(inventory);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

