/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.PurchaseOrderGeneratorServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PurchaseOrderConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.PurchaseOrderProposition;
import ch.icit.pegasus.server.core.dtos.supply.PurchaseOrderPropositionGroupComplete;
import ch.icit.pegasus.server.core.dtos.supply.PurchaseOrderPropositionGroupLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.services.supply.PurchaseOrderGeneratorService;

public class PurchaseOrderGeneratorServiceManagerImpl
implements PurchaseOrderGeneratorServiceManager {
    @Override
    public PurchaseOrderConfiguration getConfiguration() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(PurchaseOrderGeneratorService.class).getConfiguration();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<PurchaseOrderPropositionGroupLight> getAllPropositions(Integer days) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(PurchaseOrderGeneratorService.class).getAllPropositions(days);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public PurchaseOrderPropositionGroupComplete getProposition(SupplierLight supplierLight, Integer includedDays, TimestampWrapper validity, boolean useTaxZone, TaxZoneComplete tz) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(PurchaseOrderGeneratorService.class).getProposition(supplierLight, includedDays, validity, useTaxZone, tz);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public PurchaseOrderProposition updateProposition(BasicArticleLight article, SupplierLight supplier, Integer preOrderDays, boolean useTaxZone, TaxZoneComplete tz) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(PurchaseOrderGeneratorService.class).updateProposition(article, supplier, preOrderDays, useTaxZone, tz);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

