/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionDailyReportingSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionStockImageSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionTransactionExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionDataImportComplete;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionDataImportLight;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionDataImportReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.supply.RetailInMotionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetailInMotionServiceManagerImpl
implements RetailInMotionServiceManager {
    private static Logger log = LoggerFactory.getLogger(RetailInMotionServiceManagerImpl.class);

    @Override
    public void checkout(ListWrapper<RetailInMotionDataImportReference> rimData) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(RetailInMotionService.class).checkout(rimData);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void sendDailyReporting() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(RetailInMotionService.class).sendDailyReporting();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RetailInMotionDailyReportingSettingsComplete> getDailyReportingSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RetailInMotionService.class).getDailyReportingSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getSobRetailInMotionReport(ListWrapper<FlightReference> flightReferenceListWrapper) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RetailInMotionService.class).getSobRetailInMotionReport(flightReferenceListWrapper);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<FlightLight> updateRetailinMotionTransaction(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RetailInMotionService.class).updateRetailinMotionTransaction(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public ListWrapper<String> resolveFlightImport(ListWrapper<FlightReference> data, boolean resetAndResolve) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RetailInMotionService.class).resolveFlightImport(data, resetAndResolve);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RetailInMotionDataImportLight> moveTransactions(RetailInMotionDataImportLight originImport, LocationComplete targetLocation) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RetailInMotionService.class).moveTransactions(originImport, targetLocation);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void removeWayBill(FlightLight flight, String waybill) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(RetailInMotionService.class).removeWayBill(flight, waybill);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void deleteRetailInMotionData(RetailInMotionDataImportReference data) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(RetailInMotionService.class).deleteRetailInMotionData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RetailInMotionDataImportComplete> createRetailInMotionData(RetailInMotionDataImportComplete data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RetailInMotionService.class).createRetailInMotionData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public ListWrapper<String> resolveImport(ListWrapper<RetailInMotionDataImportReference> data, boolean resetAndResolve) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RetailInMotionService.class).resolveImport(data, resetAndResolve);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void moveTransactionsFiltered(FlightLight originFlight, FlightLight targetFlight, boolean outbound, boolean inbound) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(RetailInMotionService.class).moveTransactionsFiltered(originFlight, targetFlight, outbound, inbound);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void switchProductCustomer(FlightReference flight, CustomerReference originCustomer, CustomerReference targetCustomer) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(RetailInMotionService.class).switchProductCustomer(flight, originCustomer, targetCustomer);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void sendRetailInMotionStockImage() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(RetailInMotionService.class).sendRetailInMotionStockImage();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void sendRetailInMotionTransactionData() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(RetailInMotionService.class).sendRetailInMotionTransactionData();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getRetailInMotionReport2(ListWrapper<RetailInMotionDataImportReference> s, boolean extendData) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RetailInMotionService.class).getRetailInMotionReport2(s, extendData);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getRetailInMotionReport(ListWrapper<FlightReference> s, boolean extendData) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RetailInMotionService.class).getRetailInMotionReport(s, extendData);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void readRetailInMotionData() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(RetailInMotionService.class).readRetailInMotionData();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RetailInMotionDataImportComplete> getRetailInMotionData(RetailInMotionDataImportLight data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RetailInMotionService.class).getRetailInMotionData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RetailInMotionDataImportComplete> updateRetailInMotionData(RetailInMotionDataImportComplete data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(RetailInMotionService.class).updateRetailInMotionData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public Node<RetailInMotionSettingsComplete> getRetailInMotionSettingsCached() throws ClientServerCallException {
        Node<RetailInMotionSettingsComplete> rim = NodeToolkit.getAffixClass(RetailInMotionSettingsComplete.class);
        if (rim == null) {
            RetailInMotionSettingsComplete settings = (RetailInMotionSettingsComplete)this.getRetailInMotionSettings().getValue();
            rim = INodeCreator.getDefaultImpl().getNode4DTO(settings, false, false);
            rim.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(RetailInMotionSettingsComplete.class));
            NodeToolkit.addAffix(rim);
        }
        return rim;
    }

    @Override
    public Node<RetailInMotionStockImageSettingsComplete> getRetailInMotionStockImageSettingsCached() throws ClientServerCallException {
        Node<RetailInMotionStockImageSettingsComplete> rim = NodeToolkit.getAffixClass(RetailInMotionStockImageSettingsComplete.class);
        if (rim == null) {
            RetailInMotionStockImageSettingsComplete settings = (RetailInMotionStockImageSettingsComplete)this.getRetailInMotionStockImageSettings().getValue();
            rim = INodeCreator.getDefaultImpl().getNode4DTO(settings, false, false);
            rim.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(RetailInMotionStockImageSettingsComplete.class));
            NodeToolkit.addAffix(rim);
        }
        return rim;
    }

    @Override
    public Node<RetailInMotionTransactionExchangeSettingsComplete> getRetailInMotionTransactionExchangeSettingsCached() throws ClientServerCallException {
        Node<RetailInMotionTransactionExchangeSettingsComplete> rim = NodeToolkit.getAffixClass(RetailInMotionTransactionExchangeSettingsComplete.class);
        if (rim == null) {
            RetailInMotionTransactionExchangeSettingsComplete settings = (RetailInMotionTransactionExchangeSettingsComplete)this.getRetailInMotionTransactionExchangeSettings().getValue();
            rim = INodeCreator.getDefaultImpl().getNode4DTO(settings, false, false);
            rim.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(RetailInMotionTransactionExchangeSettingsComplete.class));
            NodeToolkit.addAffix(rim);
        }
        return rim;
    }

    @Override
    public OptionalWrapper<RetailInMotionSettingsComplete> getRetailInMotionSettings() throws ClientSaveOnServerException {
        try {
            return EjbContextFactory.getInstance().getService(RetailInMotionService.class).getRetailInMotionSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RetailInMotionStockImageSettingsComplete> getRetailInMotionStockImageSettings() throws ClientSaveOnServerException {
        try {
            return EjbContextFactory.getInstance().getService(RetailInMotionService.class).getRetailInMotionStockImageSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RetailInMotionTransactionExchangeSettingsComplete> getRetailInMotionTransactionExchangeSettings() throws ClientSaveOnServerException {
        try {
            return EjbContextFactory.getInstance().getService(RetailInMotionService.class).getRetailInMotionTransactionExchangeSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

