/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionComplete;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionLight;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataValidationCheckSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.internalconsumption.KonterProbenSettingsComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryProductCountComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryRecipeCountComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.MatDispoSupplierAndStoreTemplateComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.PurchaseOrderAcceptationComplete;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StockTransactionSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.AmountModificationComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupReference;
import ch.icit.pegasus.server.core.dtos.store.StockCheckoutGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckoutGroupReference;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockMovementGroupReference;
import ch.icit.pegasus.server.core.dtos.store.StoreArticleContentComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.store.transaction.IStockInventoryComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckoutComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockMovementComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockInventoryComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockTransactionComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.IStockInventoryWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.supply.StoreService;
import java.sql.Date;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StoreServiceManagerImpl
implements StoreServiceManager {
    @Override
    public void generateStockLevelCheck() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(StoreService.class).generateStockLevelCheck();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<DataValidationCheckSettingsComplete> getStockLevelCheckSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStockLevelCheckSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    public OptionalWrapper<DataValidationCheckSettingsComplete> updateStockLevelCheckSettings(DataValidationCheckSettingsComplete settings) throws ServiceException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).updateStockLevelCheckSettings(settings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<KonterProbenSettingsComplete> getKonterProbenSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getKonterProbenSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<KonterProbenSettingsComplete> updateKonterProbenSettings(KonterProbenSettingsComplete settings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).updateKonterProbenSettings(settings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void generateInventoryDateCheck() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(StoreService.class).generateInventoryDateCheck();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void generateChargeWithOnlyIRBatchesCheck() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(StoreService.class).generateChargeWithOnlyIRBatchesCheck();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void generateChargeWithoutBatchesCheck() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(StoreService.class).generateChargeWithoutBatchesCheck();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void moveAllArticles(StoreReference sourceStore, StorePositionLight targetPosition, String comment) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(StoreService.class).moveAllArticles(sourceStore, targetPosition, comment);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void generateKonterProbenManually() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(StoreService.class).generateKonterProbenManually();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<InternalConsumptionComplete> generateInternalConsumption(PegasusFileComplete file) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).generateInternalConsumption(file);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public MapWrapper<StorePositionLight, Date> getExpiryDatePerStorePositionAtTime(BasicArticleReference article, TimestampWrapper timestamp) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getExpiryDatePerStorePositionAtTime(article, timestamp);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void logInventoryException(InventoryReference inventory, BasicArticleReference article, StoreQuantityComplete quantity, StorePositionLight position) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(StoreService.class).logInventoryException(inventory, article, quantity, position);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public <T extends StoreLight> OptionalWrapper<T> deleteStore(T store) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).deleteStore(store);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public <T extends StoreLight> OptionalWrapper<T> restoreStore(T store) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).restoreStore(store);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StoreLight> consumeAllArticles(StoreReference store, String text) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).consumeAllArticles(store, text);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseOrderAcceptationComplete> updateAcceptation(PurchaseOrderAcceptationComplete charge) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).updateAcceptation(charge);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StockMovementGroupComplete> createStockMovementGroup(StockMovementGroupComplete checkoutGroup, boolean isChargeBased) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).createStockMovementGroup(checkoutGroup, isChargeBased);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StockMovementGroupComplete> getStockMovementGroup(StockMovementGroupReference checkoutGroup) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStockMovementGroup(checkoutGroup);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StockMovementGroupComplete> updateStockMovementGroup(StockMovementGroupComplete checkoutGroup, boolean isChargeBased) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).updateStockMovementGroup(checkoutGroup, isChargeBased);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StorePositionComplete> getStore(StorePositionLight store) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStore(store);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public MapWrapper<BasicArticleReference, StoreQuantityComplete> getStock(ListWrapper<BasicArticleReference> article) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStock(article);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public MapWrapper<BasicArticleReference, StoreQuantityComplete> getStockOnlyMainStore(ListWrapper<BasicArticleReference> article) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStockOnlyMainStore(article);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public Map<ManualStockCheckinComplete, String> checkin(List<ManualStockCheckinComplete> checkins) throws ClientServerCallException {
        HashMap<ManualStockCheckinComplete, String> map = new HashMap<ManualStockCheckinComplete, String>();
        for (ManualStockCheckinComplete checkin : checkins) {
            this.checkin(checkin);
        }
        return map;
    }

    @Override
    public OptionalWrapper<StorePositionLight> getPositionForId(Long id) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getPositionForId(id);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StoreComplete> createStore(StoreComplete dto) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).createStore(dto);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public <S extends StoreLight> OptionalWrapper<S> updateStore(S dto) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).updateStore(dto);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public ListWrapper<ManualStockMovementComplete> move(ManualStockMovementComplete movement, boolean isChargeBased, boolean moveWhileInventory) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).move(movement, isChargeBased, moveWhileInventory);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public void correct(IStockInventoryWrapper correction, boolean isChargeBased, boolean fromPlanner) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(StoreService.class).correct(correction, isChargeBased, fromPlanner);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public void countProducts(InventoryReference inventory, ListWrapper<InventoryProductCountComplete> productCounts) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(StoreService.class).countProducts(inventory, productCounts);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public void countRecipes(InventoryReference inventory, ListWrapper<InventoryRecipeCountComplete> recipeCounts) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(StoreService.class).countRecipes(inventory, recipeCounts);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public Map<IStockInventoryComplete, String> correct(List<? extends IStockInventoryComplete> corrections, boolean isChargeBased, boolean fromPlanner) throws ClientServerCallException {
        HashMap<IStockInventoryComplete, String> map = new HashMap<IStockInventoryComplete, String>();
        Collections.sort(corrections, new Comparator<IStockInventoryComplete>(){

            @Override
            public int compare(IStockInventoryComplete arg0, IStockInventoryComplete arg1) {
                if (arg0 instanceof StockInventoryComplete) {
                    if (arg1 instanceof StockInventoryComplete) {
                        return 0;
                    }
                    return 1;
                }
                if (arg1 instanceof StockInventoryComplete) {
                    return -1;
                }
                return 0;
            }
        });
        for (IStockInventoryComplete iStockInventoryComplete : corrections) {
            this.correct(new IStockInventoryWrapper(iStockInventoryComplete), isChargeBased, fromPlanner);
        }
        return map;
    }

    @Override
    public void validateInventoryCount(PegasusFileComplete file, StoreReference storeRef) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(StoreService.class).validateInventoryCount(file, storeRef);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<StorePositionLight> getFreeStorePositions(StoreReference store) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getFreeStorePositions(store);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<StorePositionLight> getAllFreeStorePositions() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getAllFreeStorePositions();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void checkin(ManualStockCheckinComplete checkin) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(StoreService.class).checkin(checkin);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StoreComplete> getStoreByReference(StoreReference store) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStoreByReference(store);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StoreLight> getStoreLightByReference(StoreReference store) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStoreLightByReference(store);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public StoreQuantityComplete getStockForArticle(BasicArticleReference article, TimestampWrapper validityDate) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStockForArticle(article, validityDate);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public StoreQuantityComplete getStockForStore(BasicArticleReference article, StoreReference store, TimestampWrapper validityDate) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStockForStore(article, store, validityDate);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public StoreQuantityComplete getStockInTargetUnitIfPossible(BasicArticleReference article, UnitComplete targetUnit) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStockInTargetUnitIfPossible(article, targetUnit);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public StoreQuantityComplete getMainStockInTargetUnitIfPossible(BasicArticleReference article, UnitComplete targetUnit) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getMainStockInTargetUnitIfPossible(article, targetUnit);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public StoreQuantityComplete getStockOnPositionInTargetUnitIfPossible(BasicArticleReference article, StorePositionLight storePosition, UnitComplete targetUnit) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStockOnPositionInTargetUnitIfPossible(article, storePosition, targetUnit);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<StoreLight, StoreQuantityComplete> getStockPerStore(BasicArticleReference article) throws ClientServerCallException {
        if (article == null) {
            return new MapWrapper(new HashMap());
        }
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStockPerStore(article);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<ArticleChargeBatchComplete> getBatches(BasicArticleReference article, StorePositionLight storePosition) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getBatches(article, storePosition);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ArticleChargeComplete> getCharge(ArticleChargeReference charge) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getCharge(charge);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<StorePositionLight, StoreQuantityComplete> getStockPerStorePosition(BasicArticleReference article) throws ClientServerCallException {
        if (article == null) {
            return new MapWrapper(new HashMap());
        }
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStockPerStorePosition(article);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ManualStockCheckoutComplete> checkout(ManualStockCheckoutComplete checkout) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).checkout(checkout);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Map<ManualStockCheckoutComplete, String> checkout(List<ManualStockCheckoutComplete> checkouts) {
        HashMap<ManualStockCheckoutComplete, String> map = new HashMap<ManualStockCheckoutComplete, String>();
        for (ManualStockCheckoutComplete checkout : checkouts) {
            try {
                this.checkout(checkout);
            }
            catch (ClientServerCallException e) {
                map.put(checkout, e.getMessage());
            }
        }
        return map;
    }

    @Override
    public void resetInventory(StoreReference store, UserReference user, TimestampWrapper validityDate) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(StoreService.class).resetInventory(store, user, validityDate);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public ListWrapper<ArticleChargeBatchComplete> getInventory(StoreReference store) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getInventory(store);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public ListWrapper<ArticleChargeBatchComplete> findBatchesCountedBefore(TimestampWrapper timestamp) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).findBatchesCountedBefore(timestamp);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<StockTransactionComplete> getLatestStockTransactions(BasicArticleReference article, int number) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getLatestStockTransactions(article, number);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ArticleChargeComplete> updateCharge(ArticleChargeComplete l, boolean updateOrderPosition) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).updateCharge(l, updateOrderPosition);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StockCheckoutGroupComplete> createStockCheckoutGroup(StockCheckoutGroupComplete checkoutGroup, boolean isChargeBased) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).createStockCheckoutGroup(checkoutGroup, isChargeBased);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StockCheckoutGroupComplete> updateStockCheckoutGroup(StockCheckoutGroupComplete checkoutGroup, boolean isChargeBased) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).updateStockCheckoutGroup(checkoutGroup, isChargeBased);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StockCheckinGroupComplete> createStockCheckinGroup(StockCheckinGroupComplete checkinGroup) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).createStockCheckinGroup(checkinGroup);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StockCheckinGroupComplete> updateStockCheckinGroup(StockCheckinGroupComplete checkinGroup) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).updateStockCheckinGroup(checkinGroup);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StockCheckinGroupComplete> getStockCheckinGroup(StockCheckinGroupReference checkinGroup) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStockCheckinGroup(checkinGroup);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<StockCheckoutGroupComplete> getStockCheckoutGroup(StockCheckoutGroupReference containingGroup) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStockCheckoutGroup(containingGroup);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void PrintStockTransactions(StockTransactionSearchConfiguration config) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(StoreService.class).PrintStockTransactions(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void correctStock(BasicArticleReference article, InventoryLight inventory) throws ClientServerCallException {
    }

    @Override
    public ListWrapper<BasicArticleReference> getInventoryArticles(InventoryLight inventory) throws ClientServerCallException {
        return null;
    }

    @Override
    public MapWrapper<CustomerLight, Map<BasicArticleLight, AmountModificationComplete>> getStoreForecast(TimestampWrapper start, TimestampWrapper end) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStoreForecast(start, end);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<InternalConsumptionComplete> createInternalConsumption(InternalConsumptionComplete dto) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).createInternalConsumption(dto);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<InternalConsumptionComplete> getInternalConsumption(InternalConsumptionLight dto) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getInternalConsumption(dto);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public <S extends InternalConsumptionComplete> OptionalWrapper<S> updateInternalConsumption(S dto) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).updateInternalConsumption(dto);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public SearchResult<StoreArticleContentComplete> getStoreArticleContent(BasicArticleSearchConfiguration config) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStoreArticleContent(config);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public MapWrapper<StorePositionLight, StoreQuantityComplete> getStockPerStorePositionAtTime(BasicArticleReference article, TimestampWrapper timestamp) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).getStockPerStorePositionAtTime(article, timestamp);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public OptionalWrapper<MatDispoSupplierAndStoreTemplateComplete> createSupplierStoreTemplate(MatDispoSupplierAndStoreTemplateComplete template) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).createSupplierStoreTemplate(template);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MatDispoSupplierAndStoreTemplateComplete> updateSupplierStoreTemplate(MatDispoSupplierAndStoreTemplateComplete template) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).updateSupplierStoreTemplate(template);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public OptionalWrapper<MatDispoSupplierAndStoreTemplateComplete> restoreSupplierStoreTemplate(MatDispoSupplierAndStoreTemplateComplete template) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).restoreSupplierStoreTemplate(template);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public OptionalWrapper<MatDispoSupplierAndStoreTemplateComplete> deleteSupplierStoreTemplate(MatDispoSupplierAndStoreTemplateComplete template) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(StoreService.class).deleteSupplierStoreTemplate(template);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

