/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.system;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.LoggingServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.services.system.LoggingService;

public class LoggingServiceManagerImpl
implements LoggingServiceManager {
    @Override
    public void sendBugMailToDefaultAddress(String subject, String message, String stackTrace, byte[] screenshot) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(LoggingService.class).sendBugMailToDefaultAddress(subject, message, stackTrace, screenshot);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), false, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void sendBugMail(String subject, String message, String stackTrace, byte[] screenshot, String bugMailAddress) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(LoggingService.class).sendBugMail(subject, message, stackTrace, screenshot, bugMailAddress);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), false, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void sendPurchaseOrderMail(String source, ListWrapper<String> targetList, String subject, String msg, byte[] pdf) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(LoggingService.class).sendPurchaseOrderMail(source, targetList, subject, msg, pdf);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void sendWAGOrderMail(String senderMail, ListWrapper<String> stringListWrapper, String subject, String msg, byte[] pdf) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(LoggingService.class).sendWAGOrderMail(senderMail, stringListWrapper, subject, msg, pdf);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void sendEmail(String subject, String msg, String recipient) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(LoggingService.class).sendEmail(subject, msg, recipient);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), false, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void sendServerBugMail(String subject, String message, String stackTrace) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(LoggingService.class).sendServerBugMail(subject, message, stackTrace);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), false, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

