/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.system;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataMaintenanceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.SlaveServerSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TrackedArticleCommissionExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.internalconsumption.InternalConsumptionCalculationSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.productivity.ProductivityMeasureSettingsComplete;
import ch.icit.pegasus.server.core.dtos.print.ChargeLabelPrintSettingsComplete;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.reserve.RecipeReserveSettingsComplete;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantDeliverySettingsComplete;
import ch.icit.pegasus.server.core.dtos.scan.AutoDocumentScanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.solar.SolarCompanySettingsComplete;
import ch.icit.pegasus.server.core.dtos.store.dutyfree.DutyFreeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.CustomSequenceComplete;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.system.PurchaseApprovalSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.QualitySettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SequenceIdentifierE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemViewSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.TrolleyScanSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.system.SystemSettingsService;
import java.util.List;

public class SystemSettingsServiceManagerImpl
implements SystemSettingsServiceManager {
    @Override
    public OptionalWrapper<TrackedArticleCommissionExchangeSettingsComplete> getTrackedArticleCommissionSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getTrackedArticleCommissionSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ProductivityMeasureSettingsComplete> getProductivityMeasureSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getProductivityMeasureSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<AutoDocumentScanSettingsComplete> getDocumentScanRequestSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getDocumentScanRequestSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ChargeLabelPrintSettingsComplete> getChargeLabelPrintSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getChargeLabelPrintSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseApprovalSettingsComplete> getPurchaseReleaseSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getPurchaseReleaseSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<TrolleyScanSettingsComplete> updateTrolleyScanSettings(TrolleyScanSettingsComplete settings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).updateTrolleyScanSettings(settings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Node<TrolleyScanSettingsComplete> getTrolleyScanSettingsCached() throws ClientServerCallException {
        Node<TrolleyScanSettingsComplete> node = NodeToolkit.getAffixClass(TrolleyScanSettingsComplete.class);
        if (node != null) {
            INodeCreator.getDefaultImpl().addToAllNodes(node);
        } else {
            TrolleyScanSettingsComplete settings1 = (TrolleyScanSettingsComplete)this.getTrolleyScanSettings().getValue();
            node = INodeCreator.getDefaultImpl().getNode4DTO(settings1, false, false);
            node.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(TrolleyScanSettingsComplete.class));
            NodeToolkit.addAffix(node);
        }
        return node;
    }

    @Override
    public OptionalWrapper<DutyFreeSettingsComplete> getDutyFreeSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getDutyFreeSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<QualitySettingsComplete> getQualitySettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getQualitySettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Node<QualitySettingsComplete> getQualitySettingsCached() throws ClientServerCallException {
        Node<QualitySettingsComplete> affixClass = NodeToolkit.getAffixClass(QualitySettingsComplete.class);
        if (affixClass == null) {
            OptionalWrapper<QualitySettingsComplete> qualitySettings = this.getQualitySettings();
            Node<ADTO> settings = INodeCreator.getDefaultImpl().getNode4DTO(qualitySettings.getValue(), false, false);
            settings.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(QualitySettingsComplete.class));
            NodeToolkit.addAffix(settings);
        } else {
            INodeCreator.getDefaultImpl().addToAllNodes(affixClass);
        }
        return affixClass;
    }

    @Override
    public OptionalWrapper<QualitySettingsComplete> updateQualitySettings(QualitySettingsComplete qualitySettings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).updateQualitySettings(qualitySettings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<TrolleyScanSettingsComplete> getTrolleyScanSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getTrolleyScanSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<DataMaintenanceSettingsComplete> getMaintenanceSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getMaintenanceSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<SolarCompanySettingsComplete> getSolarCompanySettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getSolarCompanySettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<SystemViewSettingsComplete> updateViewSettings(SystemViewSettingsComplete settingsComplete) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).updateViewSettings(settingsComplete);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<SystemViewSettingsComplete> getViewSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getViewSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RestaurantDeliverySettingsComplete> getRestaurantSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getRestaurantSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Node<RestaurantDeliverySettingsComplete> getRestaurantSettingsCached() throws ClientServerCallException {
        Node<RestaurantDeliverySettingsComplete> settings = NodeToolkit.getAffixClass(RestaurantDeliverySettingsComplete.class);
        if (settings != null) {
            INodeCreator.getDefaultImpl().addToAllNodes(settings);
        } else {
            RestaurantDeliverySettingsComplete dto = (RestaurantDeliverySettingsComplete)this.getRestaurantSettings().getValue();
            settings = INodeCreator.getDefaultImpl().getNode4DTO(dto, false, false);
            settings.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(RestaurantDeliverySettingsComplete.class));
            NodeToolkit.addAffix(settings);
        }
        return settings;
    }

    @Override
    public OptionalWrapper<WeeklyPlanSettingsComplete> getWeeklyPlanSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getWeeklyPlanSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Node<WeeklyPlanSettingsComplete> getWeeklyPlanSettingsCached() throws ClientServerCallException {
        Node<WeeklyPlanSettingsComplete> settings = NodeToolkit.getAffixClass(WeeklyPlanSettingsComplete.class);
        if (settings != null) {
            INodeCreator.getDefaultImpl().addToAllNodes(settings);
        } else {
            WeeklyPlanSettingsComplete dto = (WeeklyPlanSettingsComplete)this.getWeeklyPlanSettings().getValue();
            settings = INodeCreator.getDefaultImpl().getNode4DTO(dto, false, false);
            settings.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(WeeklyPlanSettingsComplete.class));
            NodeToolkit.addAffix(settings);
        }
        return settings;
    }

    @Override
    public OptionalWrapper<InternalConsumptionCalculationSettingsComplete> getInternalConsumptionCalculationSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getInternalConsumptionCalculationSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<WeeklyPlanSettingsComplete> updateWeeklyPlanSettings(WeeklyPlanSettingsComplete settings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).updateWeeklyPlanSettings(settings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<RestaurantDeliverySettingsComplete> updateRestaurantSettings(RestaurantDeliverySettingsComplete restaurantDeliverySettingsComplete) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).updateRestaurantSettings(restaurantDeliverySettingsComplete);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Node<SystemSettingsComplete> getSettingsCached() throws ClientServerCallException {
        Node<SystemSettingsComplete> settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        if (settings != null) {
            INodeCreator.getDefaultImpl().addToAllNodes(settings);
        } else {
            SystemSettingsComplete dto = (SystemSettingsComplete)this.getSettings().getValue();
            settings = INodeCreator.getDefaultImpl().getNode4DTO(dto, false, false);
            settings.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(SystemSettingsComplete.class));
            NodeToolkit.addAffix(settings);
        }
        return settings;
    }

    @Override
    public Node<PurchaseApprovalSettingsComplete> getPurchaseReleaseSettingsCached() throws ClientServerCallException {
        Node<PurchaseApprovalSettingsComplete> settings = NodeToolkit.getAffixClass(PurchaseApprovalSettingsComplete.class);
        if (settings != null) {
            INodeCreator.getDefaultImpl().addToAllNodes(settings);
        } else {
            PurchaseApprovalSettingsComplete dto = (PurchaseApprovalSettingsComplete)this.getPurchaseReleaseSettings().getValue();
            settings = INodeCreator.getDefaultImpl().getNode4DTO(dto, false, false);
            settings.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(PurchaseApprovalSettingsComplete.class));
            NodeToolkit.addAffix(settings);
        }
        return settings;
    }

    @Override
    public Node<SystemSettingsComplete> getSettingsUnCached() throws ClientServerCallException {
        NodeToolkit.removeAffixNamed(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(SystemSettingsComplete.class));
        Node<SystemSettingsComplete> settings = null;
        SystemSettingsComplete dto = (SystemSettingsComplete)this.getSettings().getValue();
        settings = INodeCreator.getDefaultImpl().getNode4DTO(dto, false, false);
        settings.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(SystemSettingsComplete.class));
        NodeToolkit.addAffix(settings);
        return settings;
    }

    @Override
    public Node<SystemViewSettingsComplete> getViewSettingsUnCached() throws ClientServerCallException {
        NodeToolkit.removeAffixNamed(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(SystemViewSettingsComplete.class));
        Node<SystemViewSettingsComplete> settings = null;
        SystemViewSettingsComplete dto = (SystemViewSettingsComplete)this.getViewSettings().getValue();
        settings = INodeCreator.getDefaultImpl().getNode4DTO(dto, false, false);
        settings.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(SystemViewSettingsComplete.class));
        NodeToolkit.addAffix(settings);
        return settings;
    }

    @Override
    public Node<List<LocationComplete>> getAllLocationsCached() throws ClientServerCallException {
        Node<List<Object>> affix = NodeToolkit.getAffixList(LocationComplete.class);
        if (affix == null) {
            List r = this.getAllLocations().getList();
            affix = INodeCreator.getDefaultImpl().createNodes(r, false);
            affix.setName(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(LocationComplete.class));
            NodeToolkit.addAffix(affix);
        }
        return affix;
    }

    @Override
    public OptionalWrapper<SystemSettingsComplete> getSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public String getServerVersion() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getServerVersion();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<SystemSettingsComplete> updateSystemSettings(SystemSettingsComplete setting) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).updateSystemSettings(setting);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    public OptionalWrapper<RecipeReserveSettingsComplete> updateRecipeReserveSettings(RecipeReserveSettingsComplete settings) throws ServiceException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).updateRecipeReserveSettings(settings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    public OptionalWrapper<RecipeReserveSettingsComplete> getRecipeReserveSettings() throws ServiceException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getRecipeReserveSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public ListWrapper<LocationComplete> getAllLocations() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getAllLocations();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<LocationComplete> createLocation(LocationComplete location) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).createLocation(location);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<LocationComplete> updateLocation(LocationComplete location) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).updateLocation(location);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    public ListWrapper<CustomSequenceComplete> localizeCustomSequence(SequenceIdentifierE identifier) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).localizeCustomSequence(identifier);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    public OptionalWrapper<CustomSequenceComplete> getCurrentCustomSequence(SequenceIdentifierE identifier) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getCurrentCustomSequence(identifier);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public ListWrapper<CustomSequenceComplete> getCustomSequences(SequenceIdentifierE identifier) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getCustomSequences(identifier);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public OptionalWrapper<CustomSequenceComplete> delocalizeCustomSequence(SequenceIdentifierE identifier) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).delocalizeCustomSequence(identifier);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public OptionalWrapper<CustomSequenceComplete> updateCustomSequence(CustomSequenceComplete customSequence) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).updateCustomSequence(customSequence);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    public String getInterfaceVersion() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getInterfaceVersion();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public void initWholeDataBase() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(SystemSettingsService.class).initWholeDataBase();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public <T extends ADTO> OptionalWrapper<T> updateSettings(T settings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).updateSettings(settings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    public OptionalWrapper<TimerServiceSettingsComplete> setTimerServiceData(TimerServiceSettingsComplete ts) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).setTimerServiceData(ts);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<SlaveServerSettingsComplete> updateSlaveServer(SlaveServerSettingsComplete sss) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).updateSlaveServer(sss);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<SlaveServerSettingsComplete> getSlaveServerSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SystemSettingsService.class).getSlaveServerSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

