/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.tracking;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.tracking.KnifeTrackingServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.knife.KnifeSpotCheckReviewComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.knife.KnifeSpotCheckReviewReference;
import ch.icit.pegasus.server.core.dtos.spotcheck.knife.KnifeSpotCheckSettingsComplete;
import ch.icit.pegasus.server.core.dtos.tracking.knife.KnifeComplete;
import ch.icit.pegasus.server.core.dtos.tracking.knife.KnifeReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.tracking.KnifeTrackingService;

public class KnifeTrackingServiceManagerImpl
implements KnifeTrackingServiceManager {
    @Override
    public OptionalWrapper<PegasusFileComplete> createKnifeTrackingReport(ListWrapper<KnifeReference> knifes, PeriodComplete period) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(KnifeTrackingService.class).createKnifeTrackingReport(knifes, period);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<KnifeSpotCheckSettingsComplete> getSpotCheckSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(KnifeTrackingService.class).getSpotCheckSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void generateSpotCheck() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(KnifeTrackingService.class).generateSpotCheck();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<KnifeSpotCheckSettingsComplete> updateSpotCheckSettings(KnifeSpotCheckSettingsComplete settings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(KnifeTrackingService.class).updateSpotCheckSettings(settings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<KnifeSpotCheckReviewComplete> getSpotCheck(KnifeSpotCheckReviewReference spotCheck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(KnifeTrackingService.class).getSpotCheck(spotCheck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<KnifeSpotCheckReviewComplete> updateSpotCheck(KnifeSpotCheckReviewComplete spotCheck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(KnifeTrackingService.class).updateSpotCheck(spotCheck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<KnifeComplete> getKnife(KnifeReference knife) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(KnifeTrackingService.class).getKnife(knife);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<KnifeComplete> updateKnife(KnifeReference knife) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(KnifeTrackingService.class).updateKnife(knife);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<KnifeComplete> createKnife(KnifeComplete knife) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(KnifeTrackingService.class).createKnife(knife);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

