/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.tracking;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.tracking.ScanningServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.TrackableItemComplete;
import ch.icit.pegasus.server.core.dtos.label.TrolleyScan;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.services.tracking.ScanningService;

public class ScanningServiceManagerImpl
implements ScanningServiceManager {
    @Override
    public UserLight login(String userId, String hostname, String sessionID) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatefulService(ScanningService.class).login(userId, hostname, sessionID);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public void logout() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getStatefulService(ScanningService.class).logout();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public TrolleyScan registerFlight(String flightCode) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatefulService(ScanningService.class).registerFlight(flightCode);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public TrolleyScan scanLabel(String labelCode) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatefulService(ScanningService.class).scanLabel(labelCode);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public TrolleyScan scanSeal(String seal) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatefulService(ScanningService.class).scanSeal(seal);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public TrolleyScan deregisterCurrentItem() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatefulService(ScanningService.class).deregisterCurrentItem();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public ListWrapper<TrackableItemComplete> getRemainingItems(FlightReference flight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatefulService(ScanningService.class).getRemainingItems(flight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public TrolleyScan deregisterFlight(String flightCode) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatefulService(ScanningService.class).deregisterFlight(flightCode);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public TrolleyScan registerTruck(String truckCode) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatefulService(ScanningService.class).registerTruck(truckCode);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public TrolleyScan finishSealScanning() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatefulService(ScanningService.class).finishSealScanning();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public TrolleyScan registerDriver(String driverBarcode) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatefulService(ScanningService.class).registerDriver(driverBarcode);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public TrolleyScan deregisterDriver() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatefulService(ScanningService.class).deregisterDriver();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public TrolleyScan deregisterTruck() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getStatefulService(ScanningService.class).deregisterTruck();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }
}

