/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHelper {
    private static final Logger logger = LoggerFactory.getLogger(ConfigHelper.class);
    private static ConfigHelper instance;
    private static String developerPropertiesPath;
    private static String propertiesPath;
    private final Properties properties = this.loadProperties();

    private ConfigHelper() {
    }

    public static ConfigHelper getInstance() {
        if (instance == null) {
            instance = new ConfigHelper();
        }
        return instance;
    }

    private Properties loadProperties() {
        Properties probs = new Properties();
        if (!this.loadXML(probs, propertiesPath)) {
            this.loadXML(probs, developerPropertiesPath);
        }
        return probs;
    }

    private boolean loadXML(Properties probs, String propertiesPath) {
        try {
            InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(propertiesPath);
            probs.loadFromXML(inStream);
            return true;
        }
        catch (InvalidPropertiesFormatException e) {
            logger.error("Invalid Properties Format while loading ConfigHelper: " + e.getMessage());
            return false;
        }
        catch (FileNotFoundException e) {
            logger.error("Properies File for ConfigHelper not found: " + e.getMessage());
            return false;
        }
        catch (IOException e) {
            logger.error("Error while loading Properties for ConfigHelper: " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            logger.error("Error while loading Properties for ConfigHelper: " + e.getMessage());
            return false;
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    static {
        developerPropertiesPath = "pegasusDev.xml";
        propertiesPath = "pegasus.xml";
    }
}

