/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util;

import ch.icit.pegasus.client.services.util.SessionEventHandler;
import ch.icit.pegasus.client.util.ExceptionHandler;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.services.exception.ClientRemoteException;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.exception.SessionException;
import org.jboss.ejb.client.RequestSendFailedException;

public class ErrorSupport {
    public static SessionEventHandler mainFrame;
    private static long maxMailsPerSeconds;
    private static long lastMailTime;

    public static void fireException(Thread t, Exception e, String msg, boolean mail, boolean stacktrace, UserComplete user) {
        if (e instanceof SessionException) {
            ExceptionHandler.getHandler().logout();
        }
        if (e instanceof RequestSendFailedException && !((RequestSendFailedException)e).canBeRetried()) {
            ExceptionHandler.getHandler().logout();
        } else {
            if (stacktrace) {
                ExceptionHandler.getHandler().fireException(t, (Throwable)new ClientRemoteException((Throwable)e, msg, null, new String[0]), false);
            }
            if (e instanceof ServiceException) {
                ServiceException se = (ServiceException)((Object)e);
                mail = se.isSendMail();
            }
            if (mail && ErrorSupport.isNewMailAllowed()) {
                ExceptionHandler.getHandler().sendMail(e, user, msg);
            }
        }
    }

    public static boolean isNewMailAllowed() {
        long minDelayBetweenMails = 1000L / maxMailsPerSeconds;
        long currentTime = System.currentTimeMillis();
        if (lastMailTime + minDelayBetweenMails < currentTime) {
            lastMailTime = currentTime;
            return true;
        }
        return false;
    }

    public static void showExceptionWindow(String msg) {
        ExceptionHandler.getHandler().showExceptionPopup(msg);
    }

    public static void fireException(Thread t, Exception e, String msg) {
        ErrorSupport.fireException(t, e, msg, true, true, null);
    }

    public static void fireException(Thread t, Exception e, String msg, boolean sendMail) {
        ErrorSupport.fireException(t, e, msg, sendMail, true, null);
    }

    public static void fireExceptionMailOnly(Thread t, Exception e, String msg) {
        ErrorSupport.fireException(t, e, msg, true, false, null);
    }

    public static void fireExceptionStacktraceOnly(Thread t, Exception e, String msg) {
        ErrorSupport.fireException(t, e, msg, false, true, null);
    }

    static {
        maxMailsPerSeconds = 1L;
        lastMailTime = 0L;
    }
}

