/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util;

import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.importer.FlightImportComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.importer.FlightImportDataSetComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.importer.FlightImportStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlightUpdaterToolkit {
    public static AirportComplete ds;
    public static AirportComplete ns;
    static Logger l;

    public static FlightComplete getFlightOrOpenIt(FlightLight flightLight, SystemSettingsComplete settings, FlightImportDataSetComplete data, List<String> warnings) throws ClientServerCallException {
        FlightComplete flight = null;
        switch (flightLight.getFlightState()) {
            case PLANNED: {
                try {
                    flight = (FlightComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).getPlannedFlightComplete(flightLight).getValue();
                }
                catch (Exception e) {
                    data.setErrorText("Unable to open Flight");
                    data.setState(FlightImportStateE.ERROR);
                    warnings.add("Unable to open Flight");
                    l.warn("Unable to get planned Flight " + flightLight.getOutboundCode() + " " + e.getMessage());
                    return null;
                }
                try {
                    flight.setFlightState(FlightStateE.OPEN);
                    flight = ServiceManagerRegistry.getService(FlightServiceManager.class).create(flight, warnings);
                    break;
                }
                catch (Exception e) {
                    data.setErrorText("Unable to open Flight");
                    data.setState(FlightImportStateE.ERROR);
                    warnings.add("Unable to open Flight");
                    l.warn("Unable to open Flight " + flightLight.getOutboundCode() + " " + e.getMessage());
                    return null;
                }
            }
            default: {
                flight = (FlightComplete)ServiceManagerRegistry.getService(FlightServiceManager.class).getFlight((FlightReference)flightLight).getValue();
            }
        }
        return flight;
    }

    /*
     * Exception decompiling
     */
    public static void updatePax(FlightLegComplete leg2, FlightComplete flight, FlightImportDataSetComplete data, FlightImportComplete flightImport, List<String> warnings) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean checkIfFirstCateringLeg(FlightComplete flight, int number) {
        int lowestLegNowithCrew = 100;
        for (FlightLegComplete fleg : flight.getLegs()) {
            if (!fleg.getCateringLeg().booleanValue() || fleg.getNumber() >= lowestLegNowithCrew) continue;
            lowestLegNowithCrew = fleg.getNumber();
        }
        return number == lowestLegNowithCrew;
    }

    private static int getNumber(String flightLegNo, PaxFigureComplete paxf, String number, FlightComplete flight, FlightImportDataSetComplete data) {
        int num = 0;
        int maxPax = 0;
        for (SeatConfigurationComplete sc : flight.getActiveStowingList().getSeatConfigurations()) {
            if (!sc.getCabinClass().equals((Object)paxf.getCabinClass())) continue;
            maxPax = sc.getNumber();
        }
        if (number.contains("+")) {
            String[] split = number.split("\\+");
            if (split.length == 2) {
                int a = Double.valueOf(split[0]).intValue();
                int b = Double.valueOf(split[1]).intValue();
                num = a + b;
            } else {
                l.warn("Flight " + flightLegNo + "  The Column assigned to " + paxf.getCabinClass().getCode() + " is malformed");
            }
        } else {
            num = Double.valueOf(number).intValue();
        }
        if (num > maxPax) {
            l.info("Flight " + flightLegNo + " Class " + paxf.getCabinClass().getCode() + " should have been set to " + num + " Passengers. But is set to " + maxPax + " because of the maximal Capacity");
            data.setHintText("Class " + paxf.getCabinClass().getCode() + " should have been set to " + num + " Passengers. But is set to " + maxPax + " because of the maximal Capacity");
        }
        return Math.min(num, maxPax);
    }

    static {
        l = LoggerFactory.getLogger(FlightUpdaterToolkit.class);
    }
}

