/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SpecialMealOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliverySpaceComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.DateUtil;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;

public class FlightToolkit {
    public static Date createAdditionalExpiryDate(SystemSettingsComplete settings, FlightLight flight, ProductComplete product) {
        Integer days;
        if (product != null) {
            ProductVariantLight variant = product.getCurrentVariant();
            if (Boolean.TRUE.equals(variant.getUseExpiryDate())) {
                Integer days2 = variant.getDefaultExpiryDate();
                if (days2 == null) {
                    days2 = 0;
                }
                return (Date)DateUtil.addDays((java.util.Date)new Date(flight.getStd().getTime()), (int)days2);
            }
            if (Boolean.TRUE.equals(flight.getCustomer().getUseCustomerSpecificDefaultExpiry())) {
                Integer days3 = flight.getCustomer().getCustomerSpecificDefaultExpiry();
                if (days3 == null) {
                    days3 = 0;
                }
                return (Date)DateUtil.addDays((java.util.Date)new Date(flight.getStd().getTime()), (int)days3);
            }
        }
        if ((days = settings.getDefaultExpiryDateFromFlightStd()) == null) {
            days = 0;
        }
        return (Date)DateUtil.addDays((java.util.Date)new Date(flight.getStd().getTime()), (int)days);
    }

    public static void syncStdStaAndLegTime(FlightComplete flight) {
        Time legSta;
        Timestamp std = flight.getStd();
        Timestamp sta = flight.getSta();
        Time legStd = flight.getStdLeg() != null ? flight.getStdLeg().getFlightTime() : null;
        Time time = legSta = flight.getStaLeg() != null ? flight.getStaLeg().getFlightTime() : null;
        if (legStd != null) {
            std = CalendarUtil.mergeTimes(std, legStd);
            flight.setStd(std);
        }
        if (legSta != null) {
            sta = CalendarUtil.mergeTimes(sta, legSta);
            flight.setSta(sta);
        }
    }

    public static void syncInOutCodeAndLegCode(FlightComplete flight) {
        String legInCode;
        String outBound = flight.getOutboundCode();
        String inBound = flight.getInboundCode();
        String legOutCode = flight.getStdLeg() != null ? flight.getStdLeg().getFlightNo() : outBound;
        String string = legInCode = flight.getStaLeg() != null ? flight.getStaLeg().getFlightNo() : inBound;
        if (legOutCode == null) {
            legOutCode = outBound;
        }
        if (legInCode == null) {
            legInCode = inBound;
        }
        if (legOutCode == null) {
            legOutCode = "";
        }
        if (legInCode == null) {
            legInCode = "";
        }
        if (!legOutCode.isEmpty()) {
            flight.setOutboundCode(legOutCode);
        }
        if (!legInCode.isEmpty()) {
            flight.setInboundCode(legInCode);
        }
    }

    public static void ensurePaxFigureTypesInserted(FlightLight flight) {
        if (Boolean.TRUE.equals(flight.getIsInvoiceClosed()) || !Boolean.TRUE.equals(flight.getCustomer().getUseMultiPax())) {
            return;
        }
        if (flight.getFlightState() == FlightStateE.CLOSED) {
            return;
        }
        List<PaxFigureTypeComplete> paxTypes = NodeToolkit.getAffixList(PaxFigureTypeComplete.class).getValue();
        HashSet<PaxFigureTypeComplete> map = new HashSet<PaxFigureTypeComplete>();
        for (PaxFigureTypeComplete t : paxTypes) {
            if (t.getIsDeleted().booleanValue()) continue;
            map.add(t);
        }
        HashSet<CabinClassComplete> allCabinClasses = new HashSet<CabinClassComplete>();
        for (FlightLegComplete leg : flight.getLegs()) {
            for (PaxFigureComplete pf : leg.getPaxFigures()) {
                allCabinClasses.add(pf.getCabinClass());
            }
        }
        for (FlightLegComplete leg : flight.getLegs()) {
            for (CabinClassComplete cc : allCabinClasses) {
                for (PaxFigureTypeComplete pft : map) {
                    boolean found = false;
                    for (PaxFigureComplete pf : leg.getPaxFigures()) {
                        if (!cc.equals((Object)pf.getCabinClass()) || !pft.equals((Object)pf.getPaxFigureType())) continue;
                        found = true;
                    }
                    if (found) continue;
                    PaxFigureComplete npf = new PaxFigureComplete();
                    npf.setClientOId(Long.valueOf(ADTO.getNextId()));
                    npf.setCabinClass(cc);
                    npf.setLeg(leg);
                    npf.setNumber(Integer.valueOf(0));
                    npf.setPaxFigureType(pft);
                    leg.getPaxFigures().add(npf);
                }
            }
        }
    }

    public static boolean isFlightFromToNSDS(FlightLight flight, SystemSettingsComplete settings) {
        for (FlightLegComplete l : flight.getLegs()) {
            if (!l.getArrivalAirport().equals((Object)settings.getNightStop()) && !l.getArrivalAirport().equals((Object)settings.getDayStop()) && !l.getDepartureAirport().equals((Object)settings.getDayStop()) && !l.getDepartureAirport().equals((Object)settings.getNightStop())) continue;
            return true;
        }
        return false;
    }

    public static void syncAdditionalSpaces(FlightComplete dto) {
        Node<?> possibleValuesLogicNode;
        Node<?> possibleValues = NodeToolkit.getAffixNamed(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(AdditionalOrderComplete.class));
        if (!((List)possibleValues.getValue()).isEmpty()) {
            for (AdditionalOrderComplete o : dto.getAdditionalOrders()) {
                if (o.getStowingPosition() == null) {
                    o.setStowingPosition((DeliverySpaceComplete)((List)possibleValues.getValue()).get(0));
                    continue;
                }
                if (((List)possibleValues.getValue()).contains(o.getStowingPosition())) continue;
                o.setStowingPosition((DeliverySpaceComplete)((List)possibleValues.getValue()).get(0));
            }
        }
        if (!((List)(possibleValuesLogicNode = NodeToolkit.getAffixNamed(ServiceManagerRegistry.getService(DefaultServiceManager.class).getAffixNameForClass(SpecialMealOrderComplete.class))).getValue()).isEmpty()) {
            for (SpecialMealOrderComplete o : dto.getSpmlOrders()) {
                if (o.getMenuType() == null || !Boolean.TRUE.equals(o.getMenuType().getAdditional())) continue;
                if (o.getStowingPosition() == null) {
                    o.setStowingPosition((DeliverySpaceComplete)((List)possibleValues.getValue()).get(0));
                    continue;
                }
                if (((List)possibleValuesLogicNode.getValue()).contains(o.getStowingPosition())) continue;
                o.setStowingPosition((DeliverySpaceComplete)((List)possibleValuesLogicNode.getValue()).get(0));
            }
        }
    }
}

