/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.io;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.io.FileTransfer;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.file.FileService;
import ch.icit.pegasus.server.core.services.file.ServerOutputStream;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileUploader<T extends PegasusFileComplete>
extends FileTransfer {
    private static final Logger log = LoggerFactory.getLogger(FileUploader.class);
    private InputStream in = null;
    private ServerOutputStream out = null;
    private T fileReference = null;

    public FileUploader(T fileRef, boolean overwrite, FileTransferListener ... listeners) throws IOException {
        super(fileRef.getLocalFile(), listeners);
        this.setExpectedSize(this.localFile.length());
        if (fileRef.getFileSuffix() == null) {
            fileRef.setFileSuffix(FilenameUtils.getExtension((String)this.localFile.getName()));
        }
        String filename = "";
        filename = fileRef.getFileName() != null ? FilenameUtils.removeExtension((String)fileRef.getFileName()) : FilenameUtils.removeExtension((String)this.localFile.getName());
        fileRef.setFileName(filename);
        this.in = new BufferedInputStream(new FileInputStream(this.localFile));
        try {
            this.out = (ServerOutputStream)EjbContextFactory.getInstance().getStatefulService(ServerOutputStream.class);
            if (this.out == null) {
                FileService fileService = (FileService)EjbContextFactory.getInstance().getService(FileService.class);
            }
        }
        catch (ServiceException e) {
            throw new IOException(e.getMessage(), e);
        }
        try {
            Object object = this.fileReference = overwrite ? fileRef : ((FileService)EjbContextFactory.getInstance().getStatelessService(FileService.class)).create(fileRef);
            if (this.out != null) {
                this.out.open(this.fileReference, false);
            } else {
                FileService fileService = (FileService)EjbContextFactory.getInstance().getService(FileService.class);
                byte[] imageBytes = new byte[(int)this.localFile.length()];
                this.in.read(imageBytes);
                fileService.uploadFile(this.fileReference, imageBytes);
            }
        }
        catch (ServiceException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void run() {
        try {
            int len;
            byte[] buf = new byte[524288];
            while ((len = this.in.read(buf)) > 0) {
                this.out.write(buf, 0, len);
                this.transferred(len);
            }
        }
        catch (IOException e) {
            this.exceptionOccured(e);
        }
        catch (ServiceException e) {
            this.exceptionOccured((Exception)((Object)e));
        }
        finally {
            try {
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (Exception e) {
                log.error("Failed to close stream (%)", (Object)e.getMessage());
            }
        }
        this.finished();
    }

    T getFileReference() {
        return this.fileReference;
    }
}

