/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.io;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.io.FileTransfer;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReadResultComplete;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.file.FileService;
import ch.icit.pegasus.server.core.services.file.ServerInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.UUID;
import javax.activation.DataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileDownloader
extends FileTransfer {
    private static final Logger log = LoggerFactory.getLogger(FileDownloader.class);
    private final ServerInputStream in;
    private OutputStream out = null;
    private DataHandler dataHandler;

    private static File createFile(String suffix) throws IOException {
        String s = suffix == null ? ".tmp" : "." + suffix;
        return File.createTempFile(UUID.randomUUID().toString(), s);
    }

    FileDownloader(PegasusFileComplete fileReference, FileTransferListener ... listeners) throws IOException {
        this(fileReference.getUri(), listeners);
    }

    FileDownloader(URI uri, FileTransferListener ... listeners) throws IOException {
        super(FileDownloader.createFile(FileDownloader.getFileSuffix(uri.getPath())), listeners);
        try {
            this.in = (ServerInputStream)EjbContextFactory.getInstance().getStatefulService(ServerInputStream.class);
            if (this.in == null) {
                FileService fileService = (FileService)EjbContextFactory.getInstance().getService(FileService.class);
                this.dataHandler = fileService.downloadFile(uri);
            }
        }
        catch (ServiceException e) {
            throw new IOException(e.getMessage(), e);
        }
        this.out = new BufferedOutputStream(new FileOutputStream(this.localFile));
        try {
            if (this.in != null) {
                this.in.open(uri);
                this.setExpectedSize(this.in.available());
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.dataHandler != null) {
                InputStream inputStream = this.dataHandler.getDataSource().getInputStream();
                byte[] b = new byte[inputStream.available()];
                inputStream.read(b);
                this.out.write(b);
            } else {
                ReadResultComplete result;
                int len;
                while ((len = (result = this.in.read(524288)).getNumBytesRead()) > 0) {
                    this.out.write(result.getData(), 0, len);
                    this.transferred(len);
                }
            }
        }
        catch (IOException e) {
            this.exceptionOccured(e);
        }
        catch (ServiceException e) {
            this.exceptionOccured((Exception)((Object)e));
        }
        finally {
            try {
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (Exception e) {
                log.error("Failed to close stream ({})", (Object)e.getMessage());
            }
        }
        this.finished();
    }
}

