/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client;

import ch.icit.pegasus.client.ApplicationSettingsLoader;
import ch.icit.pegasus.client.ScreenViewProvider;
import ch.icit.pegasus.client.SessionManagerImpl;
import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.gui.TitleBar;
import ch.icit.pegasus.client.gui.changelog.VersionUtils;
import ch.icit.pegasus.client.gui.debug.DebugWindow;
import ch.icit.pegasus.client.gui.hud.HUDPanel;
import ch.icit.pegasus.client.gui.hud.HistoryObject;
import ch.icit.pegasus.client.gui.hud.externopentool.SmartExternOpenTool;
import ch.icit.pegasus.client.gui.hud.smartscreen.RowSmartScreen;
import ch.icit.pegasus.client.gui.modules.flight.utils.NewFlightCreatedUpdater;
import ch.icit.pegasus.client.gui.modules.login.LoginModule;
import ch.icit.pegasus.client.gui.modules.noaccess.NoAccessScreen;
import ch.icit.pegasus.client.gui.submodules.SubModuleShortCut;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.GlobalKeyListener;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.MainFrameContentPanel;
import ch.icit.pegasus.client.gui.utils.Screen;
import ch.icit.pegasus.client.gui.utils.ScreenInsert;
import ch.icit.pegasus.client.gui.utils.animators.AlphaFader;
import ch.icit.pegasus.client.gui.utils.animators.AnimationListener;
import ch.icit.pegasus.client.gui.utils.animators.Animator;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.animators.Mover;
import ch.icit.pegasus.client.gui.utils.autocompletion.AutoCompletionContainer;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.helpdesk.HelpdeskSupport;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupContainer;
import ch.icit.pegasus.client.gui.utils.popup.inserts.SwitchLocationPopupInsert;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.impl.masterdata.MasterDataServiceManagerImpl;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.util.SessionEventHandler;
import ch.icit.pegasus.client.session.SessionListener;
import ch.icit.pegasus.client.session.SessionManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.ExceptionHandler;
import ch.icit.pegasus.client.util.FilePathConfiguration;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.ScreenSaver;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.general.IUniversal;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.utils.BarcodeType;
import ch.icit.utils.builder.BarcodeBuilder;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.Timer;

public class MainFrame
extends JFrame
implements LafListener,
SessionListener,
MouseListener,
MouseMotionListener,
AnimationListener,
AutoCompletionContainer,
InnerPopUpListener2,
PopupContainer,
SessionEventHandler {
    private static final long serialVersionUID = 1L;
    final int animationDuration = 700;
    private boolean isTestSystem;
    public static boolean DEBUG = true;
    public static AnimationState usedState = AnimationState.MOVEIN;
    private static String defaultFolder = System.getProperty("user.home");
    private Point backupPoint;
    private TitleBar titleBar;
    private HUDPanel hudPanel;
    private Screen contentPort;
    private Screen oldPort;
    private final List<GlobalKeyListener> keyListeners = new ArrayList<GlobalKeyListener>();
    private String currentScreenDef;
    private boolean isDragable = false;
    private static final ArrayList<InnerPopUp2> currentlyOpenPopUp = new ArrayList();
    public static boolean isTempRelease;
    private MainFrameContentPanel panel;
    private SessionManagerImpl sessionMgn;
    private final Stack<Fadable> invokeQueue = new Stack();
    private AWTEventListener allOthersListener;
    private boolean isLogin = true;
    private String currentScreenClass;
    private String latestDefName;
    private StringBuffer inputBuffer;
    private String barcode;
    private NewFlightCreatedUpdater flightChecker;
    private int applicationHorizontalBorder;
    private int applicationVerticalBorder;
    private int screenHorizontalPadding;

    public MainFrame(SessionManagerImpl sessionManager, boolean testSystem) {
        super(Words.APPLICATION_NAME);
        this.setUndecorated(true);
        this.setIsTestSystem(testSystem);
        DEBUG = Boolean.valueOf(ApplicationSettingsLoader.getLoader().getAttribute("client_debug_mode"));
        if (DEBUG) {
            new DebugWindow();
        }
        ServiceManagerRegistry.setDebugMode((boolean)DEBUG);
        this.setDefaultCloseOperation(3);
        ErrorSupport.mainFrame = this;
        ThreadSafeLoader.mainFrame = this;
        ArrayList<BufferedImage> imgs = new ArrayList<BufferedImage>();
        imgs.add(AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("application_icon_16")));
        imgs.add(AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("application_icon_24")));
        imgs.add(AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("application_icon_32")));
        imgs.add(AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("application_icon_48")));
        imgs.add(AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("application_icon_256")));
        this.setIconImages(imgs);
        this.registerKeyEvents();
        this.registerEventsForConsuming();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)ExceptionHandler.getHandler());
        this.setSessionManager(sessionManager);
        this.install();
        this.setVisible(true);
    }

    private void checkForLogout() {
        SystemSettingsComplete settings;
        Node affixClass;
        if (this.barcode == null && (affixClass = NodeToolkit.getAffixClass(SystemSettingsComplete.class)) != null && (settings = (SystemSettingsComplete)affixClass.getValue()) != null) {
            this.barcode = BarcodeBuilder.getBuilder().createBarcodeWithoutCategoryWithChecksum(CompanyUtil.getCATITCustomerId((SystemSettingsComplete)settings), "9807770077", BarcodeType.EAN_13, false);
            if (this.barcode.startsWith("0")) {
                this.barcode = this.barcode.substring(1, this.barcode.length());
            }
        }
    }

    public void setFlightChecker(NewFlightCreatedUpdater flightChecker) {
        if (this.flightChecker != null) {
            this.flightChecker.stopChecker();
        }
        this.flightChecker = flightChecker;
        if (this.flightChecker != null) {
            this.flightChecker.startChecker();
        }
    }

    public NewFlightCreatedUpdater getFlightChecker() {
        return this.flightChecker;
    }

    public static String getDefaultPath() {
        return defaultFolder;
    }

    public static void setDefaultPath(String newDefaultPath) {
        MainFrame.setDefaultPath((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), newDefaultPath);
    }

    public static void setDefaultPath(UserLight user, String newDefaultPath) {
        if (user == null) {
            return;
        }
        defaultFolder = newDefaultPath;
        FilePathConfiguration config = FilePathConfiguration.loadConfiguration(user);
        if (config == null) {
            config = new FilePathConfiguration();
        }
        config.updateProperty("latest_path", defaultFolder);
        FilePathConfiguration.saveConfiguration(user, config);
    }

    public void exitCatit() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("screen", this.currentScreenDef);
        FilterChainConfiguration.saveConfiguration("main", (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), c, ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
        FilterChainConfiguration c1 = new FilterChainConfiguration();
        c1.addProperty("location", ((LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue()).getHomeBase().getCode());
        FilterChainConfiguration.saveConfiguration("location", (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), c1, ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
    }

    public void setIsTestSystem(boolean isTestSystem) {
        this.isTestSystem = isTestSystem;
    }

    public boolean isTestSystem() {
        return this.isTestSystem;
    }

    public void addGlobalKeyListener(GlobalKeyListener listener) {
        this.keyListeners.add(listener);
    }

    public void removeGlobalKeyListener(GlobalKeyListener listener) {
        this.keyListeners.remove(listener);
    }

    public static void loadDefaultPath(UserLight user) {
        String path;
        FilePathConfiguration config = FilePathConfiguration.loadConfiguration(user);
        if (config != null && (path = config.getProperty("latest_path")) != null) {
            defaultFolder = path;
        }
    }

    public TitleBar getTitleBar() {
        return this.titleBar;
    }

    public Screen getScreen() {
        return this.contentPort;
    }

    public SessionManagerImpl getSessionManager() {
        return this.sessionMgn;
    }

    public static void openPopup(InnerPopUp2 pop) {
        currentlyOpenPopUp.add(pop);
    }

    public static void closePopup(InnerPopUp2 pop) {
        currentlyOpenPopUp.remove(pop);
    }

    private InnerPopUp2 isPopup(Component c) {
        for (InnerPopUp2 p : currentlyOpenPopUp) {
            if (p != c) continue;
            return p;
        }
        return null;
    }

    private InnerPopUp2 isCaller(Component c) {
        for (InnerPopUp2 p : currentlyOpenPopUp) {
            if (!p.isCaller(c)) continue;
            return p;
        }
        return null;
    }

    private InnerPopUp2 isInnerComponent(Component c) {
        for (InnerPopUp2 p : currentlyOpenPopUp) {
            if (!p.isInnerComponent(c)) continue;
            return p;
        }
        return null;
    }

    private void closePopups(InnerPopUp2 exception, Component c) {
        ArrayList clone = (ArrayList)currentlyOpenPopUp.clone();
        for (InnerPopUp2 p : clone) {
            if (p.isBlocking() || !p.validateContent() || p == exception || p.isInnerComponent(c)) continue;
            p.hidePopUp(new Object[0]);
        }
    }

    private void registerEventsForConsuming() {
        this.allOthersListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                MouseEvent e;
                if (currentlyOpenPopUp.size() > 0 && !isTempRelease && (e = (MouseEvent)event).getComponent() != null) {
                    Component o = e.getComponent();
                    if (o.getName() != null && (o.getName().equals("ComboBox.list") || o.getName().equals("ComboBox.scrollPane"))) {
                        return;
                    }
                    InnerPopUp2 currentPopup = null;
                    while (o != null && (currentPopup = MainFrame.this.isPopup(o)) == null) {
                        o = o.getParent();
                    }
                    if (o == null) {
                        currentPopup = MainFrame.this.isCaller(e.getComponent());
                        if (currentPopup != null) {
                            if (e.getID() == 502 && !currentPopup.isBlocking() && currentPopup.validateContent()) {
                                currentPopup.hidePopUp(new Object[0]);
                            }
                            e.consume();
                        } else {
                            currentPopup = MainFrame.this.isInnerComponent(e.getComponent());
                            if (currentPopup == null) {
                                if (e.getID() == 501) {
                                    ArrayList clone = (ArrayList)currentlyOpenPopUp.clone();
                                    for (InnerPopUp2 p : clone) {
                                        if (!p.isBlocking() && p.validateContent()) {
                                            p.hidePopUp(new Object[0]);
                                            continue;
                                        }
                                        e.consume();
                                    }
                                } else {
                                    if (e.getID() == 507) {
                                        e.consume();
                                    }
                                    for (InnerPopUp2 p : currentlyOpenPopUp) {
                                        if (!p.isBlocking()) continue;
                                        e.consume();
                                    }
                                }
                            }
                        }
                    } else if (currentPopup != null && e.getID() == 501) {
                        MainFrame.this.closePopups(currentPopup, e.getComponent());
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.allOthersListener, 131120L);
    }

    private void registerKeyEvents() {
        Toolkit.getDefaultToolkit().addAWTEventListener(event -> {
            if (event.getID() == 401) {
                KeyEvent keyEvent = (KeyEvent)event;
                if (keyEvent.getKeyCode() == 123) {
                    this.logoutImmediately();
                }
                if (currentlyOpenPopUp.size() > 0) {
                    if (keyEvent.getKeyCode() == 113) {
                        ScreenSaver.saveScreenShot2Disc(this.getContentPane());
                    } else if (keyEvent.getKeyCode() == 114 && currentlyOpenPopUp.size() > 0) {
                        ScreenSaver.savePopupToDisk(currentlyOpenPopUp);
                    }
                    return;
                }
                if (keyEvent.getKeyCode() == 112) {
                    if (this.sessionMgn.isSessionValid() && this.titleBar.isHUDAccessible()) {
                        this.showHud(!this.isHudVisible());
                    }
                } else if (keyEvent.getKeyCode() == 113) {
                    ScreenSaver.saveScreenShot2Disc(this.getContentPane());
                } else if (keyEvent.getKeyCode() == 27) {
                    if (this.isHudVisible()) {
                        this.hudPanel.escapeKeyPressed();
                    } else {
                        this.contentPort.escapeKeyPressed();
                    }
                } else if (keyEvent.getKeyCode() == 83 && keyEvent.isControlDown()) {
                    this.contentPort.saveKeyPressed();
                } else if (keyEvent.getKeyCode() == 114) {
                    if (this.isHudVisible()) {
                        ScreenSaver.saveScreenShot2Disc(this.hudPanel);
                    }
                } else if (keyEvent.getKeyCode() == 116) {
                    if (this.isHudVisible()) {
                        ScreenSaver.saveHudToDisk(this.hudPanel);
                    }
                } else if (keyEvent.getKeyCode() == 37) {
                    if (this.isHudVisible()) {
                        this.hudPanel.moveFocusLeft();
                    }
                } else if (keyEvent.getKeyCode() == 39) {
                    if (this.isHudVisible()) {
                        this.hudPanel.moveFocusRight();
                    }
                } else if (keyEvent.getKeyCode() == 38) {
                    if (this.isHudVisible()) {
                        this.hudPanel.moveFocusUp();
                    }
                } else if (keyEvent.getKeyCode() == 40) {
                    if (this.isHudVisible()) {
                        this.hudPanel.moveFocusDown();
                    }
                } else if (keyEvent.getKeyCode() == 40) {
                    if (this.isHudVisible()) {
                        this.hudPanel.moveFocusDown();
                    }
                } else if (keyEvent.getKeyCode() >= 48 && keyEvent.getKeyCode() <= 57) {
                    if (this.inputBuffer == null) {
                        this.inputBuffer = new StringBuffer();
                    }
                    this.checkForLogout();
                    String t = "" + ((KeyEvent)event).getKeyChar();
                    if (((KeyEvent)event).getKeyCode() == 8) {
                        if (this.inputBuffer.length() > 0) {
                            this.inputBuffer = new StringBuffer(this.inputBuffer.subSequence(0, this.inputBuffer.length() - 1));
                        }
                    } else {
                        this.appendToInputBuffer(t);
                    }
                    if (!StringUtil.isBlank((String)this.barcode) && this.inputBuffer.toString().contains(this.barcode)) {
                        this.logoutImmediately();
                        return;
                    }
                } else {
                    for (GlobalKeyListener l : this.keyListeners) {
                        if (!l.matchRegister(keyEvent)) continue;
                        l.process();
                        return;
                    }
                }
            }
        }, 8L);
    }

    void appendToInputBuffer(String s) {
        if (this.inputBuffer != null && this.barcode != null) {
            this.inputBuffer.append(s);
            if (this.inputBuffer.length() > this.barcode.length()) {
                this.inputBuffer.delete(0, this.inputBuffer.length() - this.barcode.length());
            }
        }
    }

    private void logoutImmediately() {
        if (this.isLogin) {
            return;
        }
        while (!currentlyOpenPopUp.isEmpty()) {
            InnerPopUp2 innerPopUp2 = currentlyOpenPopUp.get(0);
            innerPopUp2.hidePopUp(null);
            innerPopUp2.setVisible(false);
        }
        this.logout();
    }

    public void setSessionManager(SessionManagerImpl sessionMgn) {
        if (this.sessionMgn != null) {
            this.sessionMgn.removeSessionListener(this);
        }
        this.sessionMgn = sessionMgn;
        this.sessionMgn.addSessionListener(this);
    }

    public static SubModuleShortCut createShortCut(SubModuleDefinitionComplete d, int key) {
        return new SubModuleShortCut(key, true, d);
    }

    private void install() {
        this.panel = new MainFrameContentPanel(this);
        this.panel.addMouseMotionListener(this);
        this.titleBar = new TitleBar(this);
        this.setContentPane(this.panel);
        this.getContentPane().setFocusable(true);
        this.getContentPane().addMouseListener(this);
        this.lafAttributeChanged("All attribues changed");
        this.getContentPane().setLayout(new MainFrameLayout());
        this.setIsLogin(true);
        this.setSize(1024, 768);
        this.invokeQueue.push(this.titleBar);
        this.invokeFadeIn();
    }

    public void setIsLogin(boolean isLogin) {
        this.isLogin = isLogin;
        if (!this.isLogin) {
            this.titleBar.setProgress(0.0f);
            this.titleBar.updateVersionNo();
            this.getContentPane().add((Component)this.titleBar, -1);
            this.titleBar.fadeIn();
        } else {
            this.getContentPane().remove(this.titleBar);
        }
        this.panel.setLogin(isLogin);
    }

    public boolean isHudVisible() {
        if (this.hudPanel == null) {
            return false;
        }
        return this.hudPanel.isVisible();
    }

    public boolean isPopupOpen() {
        return currentlyOpenPopUp.size() > 0;
    }

    public void showHud(boolean showHud) {
        if (this.titleBar.isHUDOpenable()) {
            this.setCursor(new Cursor(3));
            this.contentPort.completeAllAnimationsImmediately();
            this.contentPort.showHud(true);
            this.setCursor(new Cursor(0));
            if (showHud != this.isHudVisible()) {
                if (showHud) {
                    if (this.hudPanel != null) {
                        this.hudPanel.kill();
                        this.hudPanel = null;
                    }
                    if (this.hudPanel == null) {
                        this.hudPanel = new HUDPanel(this, this.contentPort.getView(), ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                        this.hudPanel.setProgress(0.0f);
                        this.getContentPane().add((Component)this.hudPanel, 0);
                    }
                    this.hudPanel.setVisible(true);
                    this.hudPanel.showHUD();
                    this.getContentPane().invalidate();
                    this.getContentPane().validate();
                } else {
                    this.hudPanel.fadeOut(true);
                    this.hudPanel = null;
                }
            }
        }
    }

    public String getLatestDefName() {
        return this.latestDefName;
    }

    public void showScreen(final Screen contentPort, String defName) {
        final Screen oldScreen = this.contentPort != null && this.contentPort != contentPort ? this.contentPort : null;
        this.contentPort = contentPort;
        this.latestDefName = defName;
        if (defName != null) {
            FilterChainConfiguration c = new FilterChainConfiguration();
            c.addProperty("screen", HUDToolkit.getIdentifierForClassName(defName));
            FilterChainConfiguration.saveConfiguration("main", (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), c, ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
        }
        if (this.isHudVisible()) {
            this.hudPanel.getFader().addAnimationListener(new AnimationListener(){

                @Override
                public void animationFinished(boolean wasFadin) {
                    MainFrame.this.doScreenSwitch(contentPort, oldScreen);
                }
            });
            this.hudPanel.fadeOut(true);
            this.hudPanel = null;
        } else {
            this.doScreenSwitch(contentPort, oldScreen);
        }
    }

    private void doScreenSwitch(Screen contentPort, Screen oldScreen) {
        this.titleBar.setHUDButtonsEnabled(false, 85085);
        contentPort.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color")));
        if (oldScreen != null) {
            oldScreen.killAfterFadeOut();
        }
        boolean smartChange = this.morphScreens(this.contentPort, oldScreen);
        this.oldPort = oldScreen;
        this.getContentPane().add((Component)this.contentPort, -1);
        contentPort.animateForward(-1L);
        if (this.oldPort != null) {
            this.oldPort.animateBackward(-1L, true);
        }
        if (this.contentPort != null && this.contentPort.getView() != null && this.contentPort.getView() instanceof ScreenInsert) {
            this.contentPort.getView().screenSet();
        }
        this.validate();
    }

    public <T extends IUniversal> void openExternalTool(SmartExternOpenTool<T> tool, Component hudButton, int x, int y) {
        tool.execute(hudButton);
    }

    private boolean morphScreens(Screen newScreen, Screen oldScreen) {
        if (newScreen.getView() instanceof RowSmartScreen) {
            Animator a = new Animator(new Mover<Screen>(oldScreen, oldScreen.getX(), oldScreen.getY(), -oldScreen.getWidth(), oldScreen.getY()));
            oldScreen.setAnimator(a);
            Animator animator = new Animator(new Mover<Screen>(newScreen, this.getWidth(), oldScreen.getY(), oldScreen.getX(), oldScreen.getY()));
            newScreen.setAnimator(animator);
            if (newScreen.getView() instanceof PegasusSubModule) {
                ((Mover)animator.getAnimator()).addAnimationListener((AnimationListener)((Object)newScreen.getView()));
            }
            ((Mover)animator.getAnimator()).setAnimationDuration(700.0f);
            ((Mover)a.getAnimator()).setAnimationDuration(700.0f);
            newScreen.setLocation(this.getWidth(), oldScreen.getY());
            return true;
        }
        if (oldScreen != null && oldScreen.getView() instanceof RowSmartScreen) {
            Animator a = new Animator(new Mover<Screen>(oldScreen, oldScreen.getX(), oldScreen.getY(), this.getWidth(), oldScreen.getY()));
            oldScreen.setAnimator(a);
            Animator animator = new Animator(new Mover<Screen>(newScreen, -oldScreen.getWidth(), oldScreen.getY(), oldScreen.getX(), oldScreen.getY()));
            newScreen.setAnimator(animator);
            ((Mover)animator.getAnimator()).setAnimationDuration(700.0f);
            ((Mover)a.getAnimator()).setAnimationDuration(700.0f);
            newScreen.setLocation(-oldScreen.getWidth(), oldScreen.getY());
            return true;
        }
        Point p = this.getScreenPosition();
        int x = p.x;
        int y = p.y;
        int h = newScreen.getHeight();
        if (oldScreen != null) {
            x = oldScreen.getX();
            y = oldScreen.getY();
            h = oldScreen.getHeight();
        }
        switch (usedState) {
            case FADIN: {
                if (oldScreen != null) {
                    oldScreen.setAnimator(new Animator(new AlphaFader<Screen>(oldScreen)));
                }
                newScreen.setAnimator(new Animator(new AlphaFader<Screen>(newScreen)));
                break;
            }
            case MOVEIN: {
                if (oldScreen != null) {
                    Animator a = new Animator(new Mover<Screen>(oldScreen, oldScreen.getX(), oldScreen.getY(), oldScreen.getX(), oldScreen.getHeight() + oldScreen.getY()));
                    ((Mover)a.getAnimator()).setAnimationDuration(700.0f);
                    oldScreen.setAnimator(a);
                }
                Animator animator = new Animator(new Mover<Screen>(newScreen, x, -1 * h, x, y));
                ((Mover)animator.getAnimator()).setAnimationDuration(700.0f);
                newScreen.setAnimator(animator);
                if (newScreen.getView() instanceof PegasusSubModule) {
                    ((Mover)animator.getAnimator()).addAnimationListener((AnimationListener)((Object)newScreen.getView()));
                }
                newScreen.setLocation(x, -1 * h);
                break;
            }
        }
        return false;
    }

    public void showHUDButtons(int magicNumber) {
        this.titleBar.setHUDButtonsEnabled(true, magicNumber);
    }

    public void moveFrame(int dx, int dy) {
        this.setLocation(this.getX() - dx, this.getY() - dy);
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.getContentPane().setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color")));
        if (this.contentPort != null) {
            this.contentPort.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color")));
        }
    }

    private void invokeFadeIn() {
        if (!this.invokeQueue.isEmpty()) {
            Timer timer = new Timer(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("animationTime")) / 2, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Fadable)MainFrame.this.invokeQueue.pop()).fadeIn();
                    MainFrame.this.invokeFadeIn();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    public void showChangeLog(boolean versionCheck) {
        if (VersionUtils.showChangeLog(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), (JComponent)this.getContentPane(), versionCheck) == null && !versionCheck) {
            InnerPopupFactory.showErrorDialog("Unable to show current Change Log", "Error while read Data from Server", null, (Component)this);
        }
    }

    @Override
    public void sessionChanged(SessionManager mgn) {
        if (mgn != null && mgn.isSessionValid()) {
            this.setIsLogin(false);
            if (((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser() != null) {
                String clazz;
                String[] e;
                FilterChainConfiguration c = FilterChainConfiguration.loadConfiguration("main", (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
                FilterChainConfiguration c1 = FilterChainConfiguration.loadConfiguration("location", (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
                MainFrame.loadDefaultPath((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
                String defScreen = null;
                String defLocation = null;
                if (c != null && c.getProperties().size() > 0) {
                    e = c.getProperties().get(0);
                    defScreen = e[1];
                }
                if (c1 != null && c1.getProperties().size() > 0) {
                    e = c1.getProperties().get(0);
                    defLocation = e[1];
                }
                if (defLocation != null) {
                    List locs = (List)NodeToolkit.getAffixList(LocationComplete.class).getValue();
                    LocationComplete cLoc = (LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue();
                    LocationComplete nLoc = null;
                    for (LocationComplete l : locs) {
                        if (!l.getHomeBase().getCode().equals(defLocation)) continue;
                        nLoc = l;
                    }
                    if (nLoc != null && !cLoc.equals(nLoc)) {
                        try {
                            ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).switchLocation(nLoc);
                        }
                        catch (ClientServerCallException e2) {
                            InnerPopupFactory.showErrorDialog((Exception)((Object)e2), (Component)this);
                        }
                    }
                }
                if (defScreen != null) {
                    clazz = HUDToolkit.getScreenClassForInvoker(defScreen);
                    Class<?> rClazz = null;
                    if (clazz != null) {
                        try {
                            rClazz = Class.forName(clazz);
                            if (RowSmartScreen.class.isAssignableFrom(rClazz)) {
                                defScreen = null;
                            }
                        }
                        catch (ClassNotFoundException | NullPointerException e3) {
                            defScreen = null;
                        }
                    } else {
                        defScreen = null;
                    }
                }
                if (defScreen == null && !((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getModules().isEmpty()) {
                    defScreen = ((ModuleAccessRightComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getModules().get(0)).getModule().getInvokingName();
                }
                this.titleBar.updateVersionNo();
                this.showChangeLog(true);
                if (Boolean.TRUE.equals(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getMobileUser())) {
                    this.showScreen((Screen)ScreenViewProvider.forName(new HistoryObject(NoAccessScreen.class.getName(), "Mobile Users can't login to CATIT Desktop App", null), this), null);
                } else if (Boolean.TRUE.equals(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getDriverUser())) {
                    this.showScreen((Screen)ScreenViewProvider.forName(new HistoryObject(NoAccessScreen.class.getName(), "Driver Users can't login to CATIT Desktop App", null), this), null);
                } else if (defScreen != null) {
                    clazz = HUDToolkit.getScreenClassForInvoker(defScreen);
                    if (clazz == null) {
                        this.showScreen((Screen)ScreenViewProvider.forName(new HistoryObject(NoAccessScreen.class.getName(), "No Access granted", null), this), null);
                    } else {
                        this.showScreen((Screen)ScreenViewProvider.forName(new HistoryObject(clazz, "No Access granted", null), this), clazz);
                    }
                } else {
                    this.showScreen((Screen)ScreenViewProvider.forName(new HistoryObject(NoAccessScreen.class.getName(), "No Access granted", null), this), null);
                }
            }
        } else {
            this.showScreen(new Screen(new LoginModule(this.sessionMgn, this, true)), null);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.getContentPane().requestFocusInWindow();
        this.isDragable = !this.panel.isIntersectingResizeHandler(e.getX(), e.getY());
        this.backupPoint = new Point(e.getX(), e.getY());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private Point getScreenPosition() {
        Point p = new Point();
        p.x = this.applicationHorizontalBorder;
        p.x += this.screenHorizontalPadding;
        p.y = this.applicationVerticalBorder;
        p.y += ((Skin3Field)DefaultSkins.TitleBarTexture.createDynamicSkin()).getImageLeft(Button.ButtonState.UP).getHeight();
        return p;
    }

    public Screen getCurrenScreen() {
        return this.contentPort;
    }

    @Override
    public void animationFinished(boolean wasFadin) {
        this.getContentPane().add((Component)this.contentPort, -1);
        long time = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("smartscreen_animation_time")).intValue();
        this.contentPort.animateForward(time);
        if (this.oldPort != null) {
            this.oldPort.animateBackward(time, true);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.isDragable) {
            this.moveFrame((int)(this.backupPoint.getX() - (double)e.getX()), (int)(this.backupPoint.getY() - (double)e.getY()));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void relayoutContent() {
        this.contentPort.validate();
    }

    public void logout() {
        this.setFlightChecker(null);
        this.logout(true);
    }

    public void logout(boolean withServerLogout) {
        if (withServerLogout) {
            try {
                ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).logout();
                EjbContextFactory.getInstance().closeInitialContext();
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
            catch (IllegalStateException e) {
                System.exit(0);
            }
        }
        this.clearAllNodes(true);
        this.setIsLogin(true);
        this.sessionChanged(null);
    }

    public void clearAllNodes(boolean cleanDataCache) {
        NodeToolkit.clearAll();
        INodeCreator.getDefaultImpl().clearAllNodes();
        if (cleanDataCache) {
            MasterDataServiceManagerImpl.cache.clear();
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    public void showHelp() {
        Object o = HUDToolkit.getModuleDefinitionForInvoker(HUDToolkit.getInvokerNameForTopScreenClass(this.currentScreenClass), ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
        HelpdeskSupport.openManual(o, this);
    }

    public void setCurrentScreenClass(String classname) {
        this.currentScreenClass = classname;
    }

    @Override
    public void showShadow() {
    }

    @Override
    public void hideShadow() {
    }

    public void showUserDataChangePopup(Button userButton) {
        Node userNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), false, false);
        InnerPopupFactory.showUserContactEditPopup((Node<UserComplete>)userNode, 550, 400, userButton, new InnerPopUpListener2(){

            @Override
            public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
            }
        });
    }

    public void changeLocation(Button homeButton, int x, int y) {
        InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
        popUp.setAttributes(homeButton, true, true, Words.SWITCH_CURRENT_LOCATION);
        popUp.setView(new SwitchLocationPopupInsert(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), this));
        popUp.showPopUpWithinScreenMiddle(400, -1, null, homeButton);
    }

    public void updateVersion() {
        this.titleBar.updateVersionNo();
    }

    public void showMessageTool() {
    }

    public void showAbout() {
        VersionUtils.showAboutWindow((JComponent)this.getContentPane());
    }

    public MainFrameContentPanel getPanel() {
        return this.panel;
    }

    private class MainFrameLayout
    extends DefaultLayout
    implements AttributeListener {
        public MainFrameLayout() {
            this.attributeChanged("All attributes changed");
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            if (MainFrame.this.titleBar != null) {
                MainFrame.this.titleBar.setLocation(MainFrame.this.applicationHorizontalBorder, MainFrame.this.applicationVerticalBorder);
                MainFrame.this.titleBar.setSize(w - 2 * MainFrame.this.applicationHorizontalBorder, h);
                if (MainFrame.this.contentPort != null) {
                    if (!MainFrame.this.contentPort.isAnimating(AlphaFader.FadeType.Any)) {
                        int targetX = 20;
                        int targetY = 48;
                        if (MainFrame.this.contentPort.getX() != targetX && MainFrame.this.contentPort.getY() != targetY) {
                            MainFrame.this.contentPort.setLocation(targetX, targetY);
                        } else if (MainFrame.this.contentPort.getY() != targetY) {
                            MainFrame.this.contentPort.setLocation(MainFrame.this.contentPort.getX(), targetY);
                        } else if (MainFrame.this.contentPort.getX() != targetX) {
                            MainFrame.this.contentPort.setLocation(targetX, MainFrame.this.contentPort.getY());
                        }
                    }
                    MainFrame.this.contentPort.setSize(w - 2 * (MainFrame.this.applicationHorizontalBorder + MainFrame.this.screenHorizontalPadding), h - (MainFrame.this.titleBar.getY() + MainFrame.this.titleBar.getHeight() + MainFrame.this.applicationVerticalBorder));
                }
                if (MainFrame.this.hudPanel != null) {
                    MainFrame.this.hudPanel.setLocation(0, 0);
                    MainFrame.this.hudPanel.setSize(w, h);
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void attributeChanged(String attributeName) {
            boolean isAll = false;
            if ("All attributes changed".equals(attributeName)) {
                isAll = true;
            }
            if (isAll || "application_horizontal_border".equals(attributeName)) {
                MainFrame.this.applicationHorizontalBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("application_horizontal_border"));
                if (!isAll) {
                    this.invalidateLayout(null);
                }
            }
            if (isAll || "application_vertical_border".equals(attributeName)) {
                MainFrame.this.applicationVerticalBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("application_vertical_border"));
                if (!isAll) {
                    this.invalidateLayout(null);
                }
            }
            if (isAll || "screen_horizontal_inset".equals(attributeName)) {
                MainFrame.this.screenHorizontalPadding = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_horizontal_inset"));
                if (!isAll) {
                    this.invalidateLayout(null);
                }
            }
            if (isAll) {
                this.invalidateLayout(null);
            }
        }
    }

    public static enum AnimationState {
        FADIN,
        MOVEIN;

    }
}

