/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.actions.impl;

import ch.icit.pegasus.client.actions.ClientAction;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.server.core.dtos.file.ReportConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class ActionWithStyleSheet
implements ClientAction {
    public List<ReportFileComplete> filterStyleSheetWithReportConfiguration(SearchResult<ReportFileComplete> r, ReportTypeE reportType) throws ClientGetFromServerException {
        List results = r.getResults();
        Collections.sort(results, Ordering.natural().onResultOf((Function)new Function<ReportFileComplete, String>(){

            public String apply(ReportFileComplete input) {
                return input.getDescription();
            }
        }));
        List reportConfig = ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getReportConfiguration(reportType).getList();
        if (reportConfig != null) {
            block5: for (ReportConfigurationComplete rc : reportConfig) {
                switch (rc.getType()) {
                    case HIDE_DEFAULT: {
                        Iterator it;
                        if (!rc.getShowDefault().booleanValue()) {
                            it = results.iterator();
                            while (it.hasNext()) {
                                if (((ReportFileComplete)it.next()).getId() != null) continue;
                                it.remove();
                            }
                        }
                        if (!rc.getHideReport().booleanValue()) break;
                        it = results.iterator();
                        while (it.hasNext()) {
                            ReportFileComplete report = (ReportFileComplete)it.next();
                            if (!report.getDescription().equals(rc.getOriginReportName())) continue;
                            it.remove();
                        }
                        continue block5;
                    }
                    case MAX_LABEL_ENTRIES: {
                        break;
                    }
                    case REPLACE_IN_LOCATION: {
                        Iterator it = results.iterator();
                        LocationComplete location = (LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue();
                        if (rc.getShowReport().booleanValue() || !location.equals((Object)rc.getLocation())) break;
                        while (it.hasNext()) {
                            ReportFileComplete rfc = (ReportFileComplete)it.next();
                            if (!rfc.getDescription().equals(rc.getOriginReportName())) continue;
                            it.remove();
                        }
                        break;
                    }
                }
            }
        }
        return results;
    }
}

