/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.actions.impl;

import ch.icit.pegasus.client.actions.impl.ActionWithStyleSheet;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.PrintConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.RequisitionOrderReportConfiguration;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.util.PrinterToolkit;
import java.awt.Component;
import java.util.List;
import javax.print.PrintService;

public class PrintRequisitionOrderForDeliver
extends ActionWithStyleSheet {
    @Override
    public void performAction(Component source, ProgressListener l, Object ... objects) throws Exception {
        String defaultPrinter;
        if (l != null) {
            l.stateChanged(Words.PRINT_REQUISITION_ORDER_SHEET);
        }
        RequisitionOrderComplete order = (RequisitionOrderComplete)objects[0];
        CostCenterComplete deliveredBy = order.getDeliveredBy();
        SearchResult r = ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getReportStyleSheet(ReportTypeE.REQUISITION_ORDER_DELIVER);
        List<ReportFileComplete> styleSheets = this.filterStyleSheetWithReportConfiguration((SearchResult<ReportFileComplete>)r, ReportTypeE.REQUISITION_ORDER_DELIVER);
        if (styleSheets.isEmpty()) {
            throw new Exception("No Style Sheet for Requisition Order Deliver Sheet found");
        }
        String string = defaultPrinter = deliveredBy != null && deliveredBy instanceof InternalCostCenterComplete ? ((InternalCostCenterComplete)deliveredBy).getDefaultRequisitionDeliverPrinter() : null;
        if (defaultPrinter != null && !defaultPrinter.isEmpty()) {
            PrintService service = PrinterToolkit.converterStringToPrintService((String)defaultPrinter);
            if (service == null) {
                throw new ServiceException("Printer not found");
            }
            RequisitionOrderReportConfiguration config = new RequisitionOrderReportConfiguration();
            config.setDto((IDTO)order);
            config.setSigned(Boolean.valueOf(true));
            config.setFormat(ReportingOutputFormatE.PDF);
            config.setStylesheet(styleSheets.get(0));
            config.setDeliverDepartment(deliveredBy);
            try {
                PegasusFileComplete sheet = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createRequisitionOrderDeliverSheet(config).getValue();
                PrintConfigurationComplete printConfig = new PrintConfigurationComplete();
                printConfig.setLandscape(Boolean.valueOf(true));
                if (!PrintPopupToolkit.printFile(sheet, "", service, printConfig, false, 1)) {
                    throw new ServiceException("Printing failed");
                }
            }
            catch (ServiceException e) {
                e.printStackTrace();
            }
        }
    }
}

