/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.actions.impl;

import ch.icit.pegasus.client.actions.impl.ActionWithStyleSheet;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientCreateReportException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.report.PurchaseOrderReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.util.List;
import javax.swing.SwingUtilities;

public class SendPurchaseOrderAction
extends ActionWithStyleSheet {
    @Override
    public void performAction(Component source, ProgressListener l, Object ... objects) {
        if (l != null) {
            l.stateChanged(Words.SEND_PURCHASE_ORDER_TO_SUPPLIER);
        }
        PurchaseOrderComplete currentOrder = (PurchaseOrderComplete)objects[0];
        Object user = null;
        user = objects.length > 1 ? (UserReference)objects[1] : ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        if (currentOrder == null) {
            ScreenValidationObject o = new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Unable to send Order to Supplier via eMail.");
            SwingUtilities.invokeLater(() -> InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{o}), "Error while create Order", source));
            return;
        }
        SupplierLight supplier = currentOrder.getSupplier();
        try {
            SupplierComplete sC = (SupplierComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getSupplier((SupplierReference)supplier).getValue();
            if (sC.getOrderType().getIsEmail().booleanValue()) {
                if (l != null) {
                    l.stateChanged("Send Purchase Order to Supplier");
                }
                this.sendOrderMail(sC, currentOrder, source, (UserReference)user);
            } else if (sC.getOrderType().getName().equals("LETTER") || sC.getOrderType().getName().equals("FAX") || sC.getOrderType().getName().equals("TELEPHONE")) {
                if (l != null) {
                    l.stateChanged("Print Purchase Order for Supplier");
                }
                this.printOrder(currentOrder);
            }
        }
        catch (Exception e) {
            InnerPopupFactory.showErrorDialog(e.getMessage(), source);
        }
    }

    private void sendOrderMail(SupplierComplete supplier, PurchaseOrderComplete order, Component source, UserReference user) throws Exception {
        ((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).sendPurchaseOrderMail(new PurchaseOrderReference(order.getId()), new UserReference(user.getId()));
    }

    private void printOrder(PurchaseOrderComplete order) throws Exception {
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        SearchResult result = ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getReportStyleSheet(ReportTypeE.PURCHASE_ORDER);
        List<ReportFileComplete> styleSheets = this.filterStyleSheetWithReportConfiguration((SearchResult<ReportFileComplete>)result, ReportTypeE.PURCHASE_ORDER);
        if (styleSheets.isEmpty()) {
            throw new Exception("No Style Sheet for Purchase Order found");
        }
        PurchaseOrderReportConfiguration config = new PurchaseOrderReportConfiguration(new PurchaseOrderReference(order.getId()), s.getPoOrderIncludeCosts(), Boolean.valueOf(false));
        config.setStylesheet(styleSheets.get(0));
        config.setTitle("Purchase Order");
        config.setFormat(ReportingOutputFormatE.PDF);
        PegasusFileComplete r = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createPurchaseOrderSheet(config).getValue();
        try {
            PrintPopupToolkit.previewFile(r);
        }
        catch (ClientGetFromServerException e) {
            throw new ClientCreateReportException("IO Exception", null);
        }
    }
}

