/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.ConfigurationPanelListener;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.BackgroundedContainer;
import ch.icit.pegasus.client.gui.utils.searchbox.objectbased.SearchTextFieldObjectBased;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextFieldListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class ConfigurationPanel
extends BackgroundedContainer
implements ItemListener,
Focusable,
SearchTextFieldListener,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private ArrayList<TitledItem<?>> components = new ArrayList();
    private ArrayList<ConfigurationPanelListener> listeners = new ArrayList();
    private int defaultHeight = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_filter_chain_height"));
    private int minComboWidth = 120;
    private boolean disableEvents;

    public ConfigurationPanel() {
        this.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("filter_chain_inner_title_font_size"), LafLoader.getLafLoader().getAttribute("filter_chain_inner_title_font_type")));
        this.setLayout(new Layout());
    }

    public void addConfigurationPanelListener(ConfigurationPanelListener l) {
        this.listeners.add(l);
    }

    public void removeConfigurationPanelListener(ConfigurationPanelListener l) {
        this.listeners.remove(l);
    }

    public int getDefaultHeight() {
        return this.defaultHeight;
    }

    private void fireConfigurationEvent(String id, Object newValue) {
        if (this.disableEvents) {
            return;
        }
        for (ConfigurationPanelListener l : this.listeners) {
            l.valueChanged(id, newValue);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        for (TitledItem<?> i : this.components) {
            i.kill();
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
    }

    public void addItem(Component o, TitledItem.TitledItemOrientation orientation, String id, String title) {
        this.addItem(o, orientation, id, title, null);
    }

    public void addItem(Component o, TitledItem.TitledItemOrientation orientation, String id, String title, String toolTip) {
        TitledItem<Component> it = new TitledItem<Component>(o, title, orientation);
        if (o instanceof ComboBox) {
            ((ComboBox)o).setID(id);
            ((ComboBox)o).addItemListener(this);
        } else if (o instanceof SearchTextField) {
            ((SearchTextField)o).setID(id);
            ((SearchTextField)o).addSearchTextFieldListener(this);
        } else if (o instanceof CheckBox) {
            ((CheckBox)o).setID(id);
            ((CheckBox)o).addButtonListener(this);
            it.setInnerGap(5);
        }
        it.setTitleFont(this.getFont());
        if (toolTip != null) {
            it.getTitle().setToolTipText(toolTip);
            ((JComponent)it.getElement()).setToolTipText(toolTip);
        }
        it.setEnabled(this.isEnabled());
        this.add(it);
        this.components.add(it);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            String id = ((ComboBox)e.getSource()).getID();
            Object o = ((ComboBox)e.getSource()).getSelectedItem();
            this.fireConfigurationEvent(id, o);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        for (TitledItem<?> e : this.components) {
            CheckedListAdder.addToList(a, e);
        }
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        for (TitledItem<?> t : this.components) {
            if (!(t.getElement() instanceof Focusable)) continue;
            t.requestFocusInWindowNow();
            return;
        }
    }

    @Override
    public void textChanged(String nText, SearchTextField field) {
        String id = field.getID();
        String nV = field.getText();
        this.fireConfigurationEvent(id, nV);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source instanceof CheckBox) {
            this.fireConfigurationEvent(((CheckBox)source).getID(), ((CheckBox)source).isChecked());
        }
    }

    public int getMinComboWidth() {
        return this.minComboWidth;
    }

    public void setMinComboWidth(int minComboWidth) {
        this.minComboWidth = minComboWidth;
    }

    public boolean getDisableEvents() {
        return this.disableEvents;
    }

    public void setDisableEvents(boolean disableEvents) {
        this.disableEvents = disableEvents;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentX = 10;
            int lastY = 0;
            for (TitledItem e : ConfigurationPanel.this.components) {
                int cw = (int)e.getPreferredSize().getWidth();
                int aw = ConfigurationPanel.this.getMinComboWidth();
                if (e.getElement() instanceof ComboBox) {
                    e.setLocation(currentX, (int)(((double)parent.getHeight() - e.getPreferredSize().getHeight()) / 2.0));
                    aw = ConfigurationPanel.this.getMinComboWidth();
                    cw = 0;
                } else if (e.getElement() instanceof SearchTextFieldObjectBased) {
                    e.setLocation(currentX, (int)(((double)parent.getHeight() - e.getPreferredSize().getHeight()) / 2.0));
                    aw = 120;
                } else if (e.getElement() instanceof SearchTextField) {
                    e.setLocation(currentX, (int)(((double)parent.getHeight() - e.getPreferredSize().getHeight()) / 2.0));
                    aw = 120;
                } else if (e.getElement() instanceof CheckBox) {
                    e.setLocation(currentX, (int)((double)lastY - e.getPreferredSize().getHeight()));
                    aw = (int)((Component)e.getElement()).getPreferredSize().getWidth();
                } else if (e.getElement() instanceof MultiSelectionComboBox) {
                    e.setLocation(currentX, (int)((double)lastY - e.getPreferredSize().getHeight()));
                    aw = ConfigurationPanel.this.getMinComboWidth();
                    cw = 0;
                }
                e.setSize(cw + e.getInnerGap() + aw, (int)e.getPreferredSize().getHeight());
                currentX += e.getWidth() + 10;
                lastY = e.getY() + e.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 0;
            int w = 0;
            for (TitledItem e : ConfigurationPanel.this.components) {
                if (e.getElement() instanceof ComboBox) {
                    w += ConfigurationPanel.this.getMinComboWidth();
                } else if (e.getElement() instanceof SearchTextFieldObjectBased) {
                    w += 120;
                } else if (e.getElement() instanceof SearchTextField) {
                    w += 120;
                } else if (e.getElement() instanceof CheckBox) {
                    w += (int)((Component)e.getElement()).getPreferredSize().getWidth();
                }
                w += 10;
                if (!((double)h < e.getPreferredSize().getHeight())) continue;
                h = (int)e.getPreferredSize().getHeight();
            }
            if (ConfigurationPanel.this.components.size() > 0) {
                w -= 10;
            }
            return new Dimension(w, h += 20);
        }
    }
}

