/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.VersionDisplay;
import ch.icit.pegasus.client.gui.utils.VerticalSeparator;
import ch.icit.pegasus.client.gui.utils.buttons.AboutButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.ChangelogButton;
import ch.icit.pegasus.client.gui.utils.buttons.ExitButton;
import ch.icit.pegasus.client.gui.utils.buttons.HUDButton;
import ch.icit.pegasus.client.gui.utils.buttons.HelpButton;
import ch.icit.pegasus.client.gui.utils.buttons.HomeButton;
import ch.icit.pegasus.client.gui.utils.buttons.LogoutButton;
import ch.icit.pegasus.client.gui.utils.buttons.MaximizeButton;
import ch.icit.pegasus.client.gui.utils.buttons.MessageToolButton;
import ch.icit.pegasus.client.gui.utils.buttons.MinimizeButton;
import ch.icit.pegasus.client.gui.utils.buttons.UserButton;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.session.SessionListener;
import ch.icit.pegasus.client.session.SessionManager;
import ch.icit.pegasus.client.util.DisplayUtils;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;

public class TitleBar
extends JPanelFadable
implements LafListener,
AttributeListener,
MouseListener,
MouseMotionListener,
SessionListener,
ImageConsumer,
ButtonListener {
    private static final long serialVersionUID = 1L;
    private boolean isHUDReady = true;
    private static BufferedImage logoImage;
    private TextLabel testSystemTitle;
    private VersionDisplay versionDisplay;
    private LogoutButton logoutButton;
    private HUDButton hudButton;
    private HelpButton helpButton;
    private ChangelogButton changelogButton;
    private UserButton userButton;
    private AboutButton aboutToolButton;
    private MessageToolButton messageToolButton;
    private VerticalSeparator separator;
    private MinimizeButton minimizeButton;
    private MaximizeButton maximizeButton;
    private ExitButton exitButton;
    private HomeButton homeButton;
    private int blockingNumber;
    private boolean isBlockingEnabled;
    private boolean isMaximized;
    private Point backupPoint;
    private Dimension backupDimension;
    private Point dragPoint;
    private Skin3Field skin;
    private MainFrame mainFrame;
    private int gapBetweenIcons = 0;
    private int innerHorizontalTitleBorder = 0;

    public TitleBar(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.install(mainFrame);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.blockingNumber % 5 != 0 && isEnabled == this.isBlockingEnabled) {
            this.logoutButton.setEnabled(isEnabled);
        }
        if (this.blockingNumber % 7 != 0 && isEnabled == this.isBlockingEnabled) {
            this.hudButton.setEnabled(isEnabled);
            this.changelogButton.setEnabled(isEnabled);
        }
        if (this.blockingNumber % 17 != 0 && isEnabled == this.isBlockingEnabled) {
            this.userButton.setEnabled(isEnabled);
            this.homeButton.setEnabled(isEnabled);
        }
    }

    public boolean isHUDOpenable() {
        if (this.hudButton.isEnabled()) {
            if (ThreadSafeLoader.isOperationFinished()) {
                return true;
            }
            InnerPopupFactory.showErrorDialog("<b>Unable to show HUD</b><br/>Please finish all print/save Processes first!", (Component)this);
        }
        return false;
    }

    public void setHUDButtonsEnabled(boolean isEnabled, int magicNumber) {
        this.blockingNumber = magicNumber;
        this.isBlockingEnabled = isEnabled;
        if (magicNumber % 5 == 0) {
            this.logoutButton.setEnabled(isEnabled);
        }
        if (magicNumber % 7 == 0) {
            this.isHUDReady = isEnabled;
            this.hudButton.setEnabled(isEnabled);
            this.changelogButton.setEnabled(isEnabled);
        }
        if (magicNumber % 17 == 0) {
            this.userButton.setEnabled(isEnabled);
            this.homeButton.setEnabled(isEnabled);
        }
    }

    public boolean isHUDAccessible() {
        return this.isHUDReady;
    }

    public void updateVersionNo() {
        if (this.versionDisplay != null) {
            this.versionDisplay.updateString();
        }
    }

    private void install(MainFrame mainFrame2) {
        this.skin = (Skin3Field)DefaultSkins.TitleBarTexture.createDynamicSkin();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (mainFrame2.isTestSystem()) {
            this.testSystemTitle = new TextLabel(Words.TEST_SYSTEM);
            this.testSystemTitle.setFont(this.testSystemTitle.getFont().deriveFont(1, 18.0f));
            this.testSystemTitle.setForeground(new Color(255, 153, 0));
            this.testSystemTitle.setForegroundColor2(new Color(255, 0, 0));
            this.testSystemTitle.setEnabled(true);
            this.testSystemTitle.setEmbossed(true);
        }
        this.versionDisplay = new VersionDisplay(mainFrame2);
        this.versionDisplay.setProgress(0.0f);
        this.setFocusable(true);
        this.mainFrame.getSessionManager().addSessionListener(this);
        this.setLayout(new TitleBarLayout());
        this.setOpaque(false);
        this.logoutButton = new LogoutButton();
        this.hudButton = new HUDButton();
        this.aboutToolButton = new AboutButton();
        this.homeButton = new HomeButton();
        this.changelogButton = new ChangelogButton();
        this.separator = new VerticalSeparator();
        this.separator.setBackground(new Color(102, 102, 102));
        this.minimizeButton = new MinimizeButton();
        this.maximizeButton = new MaximizeButton();
        this.exitButton = new ExitButton();
        this.userButton = new UserButton();
        this.helpButton = new HelpButton();
        this.setFocusTraversalPolicyProvider(false);
        this.setFocusCycleRoot(false);
        this.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
        this.exitButton.addButtonListener(this);
        this.logoutButton.addButtonListener(this);
        this.hudButton.addButtonListener(this);
        this.aboutToolButton.addButtonListener(this);
        this.helpButton.addButtonListener(this);
        this.userButton.addButtonListener(this);
        this.homeButton.addButtonListener(this);
        this.changelogButton.addButtonListener(this);
        this.minimizeButton.addButtonListener(this);
        this.maximizeButton.addButtonListener(this);
        this.sessionChanged(this.mainFrame.getSessionManager());
        this.loadTooltip();
        this.versionDisplay.setProgress(1.0f);
        this.add(this.versionDisplay);
        this.add(this.logoutButton);
        this.add(this.hudButton);
        this.add(this.userButton);
        this.add(this.aboutToolButton);
        this.add(this.helpButton);
        this.add(this.homeButton);
        this.add(this.changelogButton);
        this.add(this.separator);
        this.add(this.minimizeButton);
        this.add(this.maximizeButton);
        this.add(this.exitButton);
        if (this.testSystemTitle != null) {
            this.add(this.testSystemTitle);
        }
        this.validate();
    }

    private void loadTooltip() {
        this.aboutToolButton.setToolTipText(Words.ABOUT);
        this.changelogButton.setToolTipText(Words.SHOW_CHANGELOG);
        this.helpButton.setToolTipText(Words.SHOW_HELP);
        this.homeButton.setToolTipText(Words.CHANGE_LOCATION);
        this.userButton.setToolTipText(Words.USER_SETTINGS);
        this.hudButton.setToolTipText(Words.SHOWS_HUD);
        this.logoutButton.setToolTipText(Words.LOGOUT);
        this.exitButton.setToolTipText(Words.QUIT_CAT_IT);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, 0, this.getWidth(), Button.ButtonState.UP);
        g2.drawImage(logoImage, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 10.0f, (this.getHeight() - logoImage.getHeight()) / 2 + 2), null);
        this.paintChildren(g2);
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, this.getPreferredHeight());
    }

    public int getPreferredHeight() {
        return this.skin.getImageMiddle(Button.ButtonState.UP).getHeight();
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName) || "horizontal_icon_gap_in_title".equals(attributeName) || "inner_horizontal_title_border".equals(attributeName)) {
            this.gapBetweenIcons = Integer.valueOf(AttributeLoader.getAttributeLoader().getAttribute("horizontal_icon_gap_in_title"));
            this.innerHorizontalTitleBorder = Integer.valueOf(AttributeLoader.getAttributeLoader().getAttribute("inner_horizontal_title_border"));
            this.setSize(this.getWidth(), this.getHeight());
            this.repaint(32L);
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.loadImages();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
            this.maximizeWindow();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dragPoint = new Point(e.getX(), e.getY());
        this.requestFocusInWindow();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.mainFrame != null && this.dragPoint != null) {
            this.mainFrame.moveFrame((int)(this.dragPoint.getX() - (double)e.getX()), (int)(this.dragPoint.getY() - (double)e.getY()));
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void sessionChanged(SessionManager mgn) {
        if (mgn.isTitleIconAllowed(3)) {
            this.exitButton.setVisible(true);
        } else {
            this.exitButton.setVisible(false);
        }
        if (mgn.isTitleIconAllowed(5)) {
            this.logoutButton.setVisible(true);
        } else {
            this.logoutButton.setVisible(false);
        }
        if (mgn.isTitleIconAllowed(7)) {
            this.hudButton.setVisible(true);
            this.changelogButton.setVisible(true);
        } else {
            this.hudButton.setVisible(false);
            this.changelogButton.setVisible(false);
        }
        if (mgn.isTitleIconAllowed(13)) {
            this.aboutToolButton.setVisible(true);
            this.helpButton.setVisible(true);
        } else {
            this.aboutToolButton.setVisible(false);
            this.helpButton.setVisible(false);
        }
        if (mgn.isTitleIconAllowed(11)) {
            this.userButton.setVisible(true);
            this.homeButton.setVisible(true);
        } else {
            this.userButton.setVisible(false);
            this.homeButton.setVisible(true);
        }
        if (this.testSystemTitle != null) {
            this.testSystemTitle.setVisible(true);
        }
        this.validate();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.versionDisplay != null) {
            this.versionDisplay.kill();
        }
        if (this.logoutButton != null) {
            this.logoutButton.kill();
        }
        if (this.hudButton != null) {
            this.hudButton.kill();
        }
        if (this.helpButton != null) {
            this.helpButton.kill();
        }
        if (this.userButton != null) {
            this.userButton.kill();
        }
        if (this.separator != null) {
            this.separator.kill();
        }
        if (this.minimizeButton != null) {
            this.minimizeButton.kill();
        }
        if (this.maximizeButton != null) {
            this.maximizeButton.kill();
        }
        if (this.exitButton != null) {
            this.exitButton.kill();
        }
        if (this.homeButton != null) {
            this.homeButton.kill();
        }
        if (this.changelogButton != null) {
            this.changelogButton.kill();
        }
        if (this.aboutToolButton != null) {
            this.aboutToolButton.kill();
        }
        if (this.testSystemTitle != null) {
            this.testSystemTitle.kill();
        }
        this.versionDisplay = null;
        this.logoutButton = null;
        this.hudButton = null;
        this.helpButton = null;
        this.userButton = null;
        this.separator = null;
        this.minimizeButton = null;
        this.maximizeButton = null;
        this.exitButton = null;
        this.homeButton = null;
        this.changelogButton = null;
        this.aboutToolButton = null;
        this.testSystemTitle = null;
    }

    @Override
    public void loadImages() {
        if (logoImage == null) {
            logoImage = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("titlebar_logo"));
        }
    }

    private void maximizeWindow() {
        if (this.isMaximized) {
            this.mainFrame.setSize((int)this.backupDimension.getWidth(), (int)this.backupDimension.getHeight());
            this.mainFrame.setLocation((int)this.backupPoint.getX(), (int)this.backupPoint.getY());
            this.isMaximized = false;
        } else {
            if (this.backupPoint == null) {
                this.backupPoint = new Point();
            }
            this.backupPoint.setLocation(this.mainFrame.getX(), this.mainFrame.getY());
            if (this.backupDimension == null) {
                this.backupDimension = new Dimension();
            }
            this.backupDimension.setSize(this.mainFrame.getWidth(), this.mainFrame.getHeight());
            DisplayUtils.maximizeFrame(this.mainFrame);
            this.isMaximized = true;
        }
        this.mainFrame.relayoutContent();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.hudButton) {
            this.mainFrame.showHud(!this.mainFrame.isHudVisible());
        } else if (source == this.exitButton) {
            String t = "";
            if (this.mainFrame.getScreen().getView() instanceof ScreenTableView) {
                ScreenTableView v = (ScreenTableView)this.mainFrame.getScreen().getView();
                if (v.isExpanded()) {
                    t = Words.ALL_UNSAVED_DATE_WILL_BE_LOST + "<br/><br/><b>" + Words.CONTINUE_AND_EXIT_ANYWAY + "</b>";
                }
            } else {
                t = Words.ALL_UNSAVED_DATE_WILL_BE_LOST + "<br/><br/><b>" + Words.CONTINUE_AND_EXIT_ANYWAY + "</b>";
            }
            InnerPopupFactory.showDesicionPopup(Words.EXIT_CATIT, "<b>" + Words.ARE_YOU_SURE_TO_EXIT + "</b><br/>" + t, source, (source1, xargs) -> {
                if (xargs == null) {
                    return;
                }
                this.mainFrame.logout();
                System.exit(0);
            }, 250, -1, PopupType.NORMAL);
        } else if (source == this.maximizeButton) {
            this.maximizeWindow();
        } else if (source == this.minimizeButton) {
            this.mainFrame.setExtendedState(1);
        } else if (source == this.logoutButton) {
            String t = "";
            if (this.mainFrame.getScreen().getView() instanceof ScreenTableView) {
                ScreenTableView v = (ScreenTableView)this.mainFrame.getScreen().getView();
                if (v.isExpanded()) {
                    t = Words.ALL_UNSAVED_DATE_WILL_BE_LOST + "<br/><br/><b>" + Words.CONTINUE_AND_EXIT_ANYWAY + "</b>";
                }
            } else {
                t = Words.ALL_UNSAVED_DATE_WILL_BE_LOST + "<br/><br/><b>" + Words.CONTINUE_AND_EXIT_ANYWAY + "</b>";
            }
            InnerPopupFactory.showDesicionPopup(Words.LOGOUT, "<b>" + Words.ARE_YOU_SURE_TO_LOGOUT + "</b><br/>" + t, source, new InnerPopUpListener2(){

                @Override
                public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                    if (xargs == null) {
                        return;
                    }
                    TitleBar.this.mainFrame.logout();
                }
            }, 250, -1, PopupType.NORMAL);
        } else if (source == this.helpButton) {
            this.mainFrame.showHelp();
        } else if (source == this.aboutToolButton) {
            this.mainFrame.showAbout();
        } else if (source == this.userButton) {
            this.mainFrame.showUserDataChangePopup(this.userButton);
        } else if (source == this.homeButton) {
            this.mainFrame.changeLocation(this.homeButton, x, y);
        } else if (source == this.changelogButton) {
            this.mainFrame.showChangeLog(false);
        }
    }

    @Override
    public void clearImages() {
        logoImage = null;
        this.loadImages();
    }

    private class TitleBarLayout
    extends DefaultLayout {
        private TitleBarLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int aHeight = TitleBar.this.skin.getImageMiddle(Button.ButtonState.UP).getHeight();
            int w = parent.getWidth();
            int currentX = TitleBar.this.skin.getImageLeft(Button.ButtonState.UP).getWidth() + logoImage.getWidth() + 20;
            if (TitleBar.this.testSystemTitle != null) {
                TitleBar.this.testSystemTitle.setLocation(currentX, (int)(((double)parent.getHeight() - TitleBar.this.testSystemTitle.getPreferredSize().getHeight()) / 2.0) - 2);
                TitleBar.this.testSystemTitle.setSize(TitleBar.this.testSystemTitle.getPreferredSize());
                currentX = TitleBar.this.testSystemTitle.getX() + TitleBar.this.testSystemTitle.getWidth() + 5;
            }
            if (TitleBar.this.versionDisplay != null) {
                TitleBar.this.versionDisplay.setLocation(currentX, (int)(((double)parent.getHeight() - TitleBar.this.versionDisplay.getPreferredSize().getHeight()) / 2.0));
                TitleBar.this.versionDisplay.setSize(TitleBar.this.versionDisplay.getPreferredSize());
            }
            TitleBar.this.exitButton.setSize((int)TitleBar.this.exitButton.getPreferredSize().getWidth(), (int)TitleBar.this.exitButton.getPreferredSize().getWidth());
            currentX = w - (TitleBar.this.innerHorizontalTitleBorder + TitleBar.this.exitButton.getWidth());
            if (TitleBar.this.exitButton.isVisible()) {
                TitleBar.this.exitButton.setLocation(currentX, (aHeight - TitleBar.this.exitButton.getHeight()) / 2);
                currentX -= TitleBar.this.gapBetweenIcons / 2 + TitleBar.this.exitButton.getWidth();
            }
            if (TitleBar.this.maximizeButton.isVisible()) {
                TitleBar.this.maximizeButton.setSize(TitleBar.this.maximizeButton.getPreferredSize());
                TitleBar.this.maximizeButton.setLocation(currentX, (aHeight - TitleBar.this.maximizeButton.getHeight()) / 2);
                currentX -= TitleBar.this.gapBetweenIcons / 2 + TitleBar.this.maximizeButton.getWidth();
            }
            if (TitleBar.this.minimizeButton.isVisible()) {
                TitleBar.this.minimizeButton.setSize(TitleBar.this.minimizeButton.getPreferredSize());
                TitleBar.this.minimizeButton.setLocation(currentX, (aHeight - TitleBar.this.minimizeButton.getHeight()) / 2);
                currentX -= TitleBar.this.gapBetweenIcons;
            }
            if (TitleBar.this.separator.isVisible()) {
                TitleBar.this.separator.setLocation(currentX, 1);
                TitleBar.this.separator.setSize(1, parent.getHeight() - 2);
                currentX -= TitleBar.this.gapBetweenIcons + TitleBar.this.separator.getWidth() + TitleBar.this.minimizeButton.getWidth();
            }
            if (TitleBar.this.logoutButton.isVisible()) {
                TitleBar.this.logoutButton.setSize((int)TitleBar.this.logoutButton.getPreferredSize().getWidth(), (int)TitleBar.this.logoutButton.getPreferredSize().getWidth());
                TitleBar.this.logoutButton.setLocation(currentX, (int)(((double)parent.getHeight() - TitleBar.this.logoutButton.getPreferredSize().getHeight()) / 2.0));
                currentX -= TitleBar.this.gapBetweenIcons + TitleBar.this.logoutButton.getWidth();
            }
            if (TitleBar.this.hudButton.isVisible()) {
                TitleBar.this.hudButton.setSize((int)TitleBar.this.hudButton.getPreferredSize().getWidth(), (int)TitleBar.this.hudButton.getPreferredSize().getWidth());
                TitleBar.this.hudButton.setLocation(currentX, TitleBar.this.logoutButton.getY() - 1);
                currentX -= TitleBar.this.gapBetweenIcons + TitleBar.this.hudButton.getWidth();
            }
            if (TitleBar.this.userButton.isVisible()) {
                TitleBar.this.userButton.setSize(TitleBar.this.userButton.getPreferredSize());
                TitleBar.this.userButton.setLocation(currentX, TitleBar.this.hudButton.getY() + 1);
                currentX -= TitleBar.this.gapBetweenIcons + TitleBar.this.userButton.getWidth();
            }
            if (TitleBar.this.homeButton.isVisible()) {
                TitleBar.this.homeButton.setSize(TitleBar.this.homeButton.getPreferredSize());
                TitleBar.this.homeButton.setLocation(currentX, TitleBar.this.hudButton.getY() + 1);
                currentX -= TitleBar.this.gapBetweenIcons + TitleBar.this.homeButton.getWidth();
            }
            if (TitleBar.this.helpButton.isVisible()) {
                TitleBar.this.helpButton.setSize(TitleBar.this.helpButton.getPreferredSize());
                TitleBar.this.helpButton.setLocation(currentX, TitleBar.this.hudButton.getY());
                currentX -= TitleBar.this.gapBetweenIcons + TitleBar.this.helpButton.getWidth();
            }
            if (TitleBar.this.changelogButton.isVisible()) {
                TitleBar.this.changelogButton.setSize(TitleBar.this.changelogButton.getPreferredSize());
                TitleBar.this.changelogButton.setLocation(currentX, TitleBar.this.hudButton.getY());
                currentX -= TitleBar.this.gapBetweenIcons + TitleBar.this.changelogButton.getWidth();
            }
            if (TitleBar.this.aboutToolButton.isVisible()) {
                TitleBar.this.aboutToolButton.setSize(TitleBar.this.aboutToolButton.getPreferredSize());
                TitleBar.this.aboutToolButton.setLocation(currentX, TitleBar.this.hudButton.getY());
                currentX -= TitleBar.this.gapBetweenIcons + TitleBar.this.aboutToolButton.getWidth();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

