/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.batch;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.BatchWorkStateE;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class BatchList<V, T extends BatchJob<V>>
extends ScrollableBackground {
    private static final long serialVersionUID = 1L;
    private List<T> batches = new ArrayList<T>();

    public BatchList() {
        super(false);
        this.getViewPort().setLayout(new Layout());
    }

    public BatchJob<V> isBlocked(Node<V> node) {
        for (BatchJob b : this.batches) {
            if (!b.isModal() || b.getJobState() == BatchWorkStateE.DONE || !b.getNode().equals(node)) continue;
            return b;
        }
        return null;
    }

    public void addBatch(T batch) {
        this.batches.add(0, batch);
        ((BatchJob)batch).setBatchList(this);
        this.getViewPort().add((Component)batch);
        this.revalidate();
        SwingUtilities.invokeLater(() -> batch.startJob());
    }

    public void removeBatch(BatchJob<V> batch) {
        this.batches.remove(batch);
        batch.kill();
        this.revalidate();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = 0;
            for (BatchJob batch : BatchList.this.batches) {
                batch.setLocation(0, y);
                batch.setSize(parent.getWidth(), (int)batch.getPreferredSize().getHeight());
                y += batch.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int y = 0;
            for (BatchJob batch : BatchList.this.batches) {
                y = (int)((double)y + batch.getPreferredSize().getHeight());
            }
            return new Dimension(0, y);
        }
    }
}

