/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.breadcrumb;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbTable;
import ch.icit.pegasus.client.gui.modules.product.details.utils.GroupComparator;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.GroupLoader;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2ViewFactory;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import java.util.List;

public abstract class BreadCrumbComponentTable
extends BreadCrumbTable {
    private static final long serialVersionUID = 1L;
    protected GroupLoader loader;

    public BreadCrumbComponentTable(IDataHandler dataHandler, BreadCrumbPanel master, GroupLoader loader, String buttonText, RDProvider provider, Node node) {
        super(dataHandler, master, buttonText, provider, node);
        this.loader = loader;
        if (this.getTotalConverter() != null) {
            this.totalCompPrice = new ReloadablePriceView((LoadingGroup)this.loader, this.getTotalConverter());
            this.totalCompPrice.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
            this.setTotalCostAlgorithm();
            this.totalCompPrice.setProgress(1.0f);
            if (this.loader != null) {
                this.loader.addSubTotal(this.totalCompPrice);
            }
            this.totalCompPrice.load(true);
            this.add(this.totalCompPrice);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.loader != null) {
            this.loader.removeSubTotal(this.totalCompPrice);
        }
        if (this.totalCompPrice != null) {
            this.totalCompPrice.kill();
        }
        this.totalCompPrice = null;
    }

    public abstract Converter getTotalConverter();

    public abstract void setTotalCostAlgorithm();

    public abstract Table2RowPanel getComponentTableRow(Table2RowModel var1, boolean var2);

    public abstract void addButtonPressed(int var1, int var2);

    public abstract void childRemoved();

    public abstract List<TableColumnInfo> getColumns(Node var1);

    @Override
    protected void install(Node node) {
        this.table = new Table2(false, "");
        this.table.setProvider(this.provider);
        this.table.setComparator(ComparatorRegistry.getComparator(GroupComparator.class));
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                BreadCrumbComponentTable.this.childRemoved();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                BreadCrumbComponentTable.this.addButtonPressed(x, y);
            }
        });
        this.table.setModel(new Table2Model(this.getColumns(node), new Table2ViewFactory(){

            @Override
            public Table2HeaderPanel getHeaderPane(Table2RowModel model) {
                return BreadCrumbComponentTable.this.getHeaderRow(model);
            }

            @Override
            public Table2RowPanel getRowPanel(Table2RowModel model) {
                return BreadCrumbComponentTable.this.getComponentTableRow(model, false);
            }
        }));
    }

    public Table2HeaderPanel getHeaderRow(Table2RowModel model) {
        return new Table2HeaderPanel(model, 7);
    }

    public Node<?> getTableNode() {
        Node n = this.table.getModel().getNode().getParent();
        return n;
    }
}

